@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId Alert rule ID
 * @property workspaceName The name of the workspace.
 */
public data class GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs(
    public val resourceGroupName: String,
    public val ruleId: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleId(ruleId.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs].
 */
@PulumiTagMarker
public class GetMicrosoftSecurityIncidentCreationAlertRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleId: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nruhnjafnlacncwi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("crdvxysybdiiwkjl")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("oahirycvevhmdrju")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs =
        GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
