@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetTIDataConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataConnectorId Connector ID
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetTIDataConnectorPlainArgs(
    public val dataConnectorId: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetTIDataConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetTIDataConnectorPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetTIDataConnectorPlainArgs.builder()
            .dataConnectorId(dataConnectorId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTIDataConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetTIDataConnectorPlainArgsBuilder internal constructor() {
    private var dataConnectorId: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Connector ID
     */
    @JvmName("eevdpwcogfnibwyv")
    public suspend fun dataConnectorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataConnectorId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bbkwiryywtqpbfyl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ivqybqqopojrtdwm")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetTIDataConnectorPlainArgs = GetTIDataConnectorPlainArgs(
        dataConnectorId = dataConnectorId ?: throw PulumiNullFieldException("dataConnectorId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
