@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GitHubResourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resources created in GitHub repository.
 * @property appInstallationId GitHub application installation id.
 */
public data class GitHubResourceInfoArgs(
    public val appInstallationId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GitHubResourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GitHubResourceInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.GitHubResourceInfoArgs.builder()
            .appInstallationId(appInstallationId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubResourceInfoArgs].
 */
@PulumiTagMarker
public class GitHubResourceInfoArgsBuilder internal constructor() {
    private var appInstallationId: Output<String>? = null

    /**
     * @param value GitHub application installation id.
     */
    @JvmName("inbnurcetprixurv")
    public suspend fun appInstallationId(`value`: Output<String>) {
        this.appInstallationId = value
    }

    /**
     * @param value GitHub application installation id.
     */
    @JvmName("tsphbrukwqjfkera")
    public suspend fun appInstallationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appInstallationId = mapped
    }

    internal fun build(): GitHubResourceInfoArgs = GitHubResourceInfoArgs(
        appInstallationId = appInstallationId,
    )
}
