@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.MetadataCategoriesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ies for the solution content item
 * @property domains domain for the solution content item
 * @property verticals Industry verticals for the solution content item
 */
public data class MetadataCategoriesArgs(
    public val domains: Output<List<String>>? = null,
    public val verticals: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.MetadataCategoriesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.MetadataCategoriesArgs =
        com.pulumi.azurenative.securityinsights.inputs.MetadataCategoriesArgs.builder()
            .domains(domains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .verticals(verticals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MetadataCategoriesArgs].
 */
@PulumiTagMarker
public class MetadataCategoriesArgsBuilder internal constructor() {
    private var domains: Output<List<String>>? = null

    private var verticals: Output<List<String>>? = null

    /**
     * @param value domain for the solution content item
     */
    @JvmName("dugqyljwiqnpiwfe")
    public suspend fun domains(`value`: Output<List<String>>) {
        this.domains = value
    }

    @JvmName("esiladaptnqwpotc")
    public suspend fun domains(vararg values: Output<String>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values domain for the solution content item
     */
    @JvmName("lhvmgbymipkwkeuv")
    public suspend fun domains(values: List<Output<String>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value Industry verticals for the solution content item
     */
    @JvmName("lbmkfrmorminfmla")
    public suspend fun verticals(`value`: Output<List<String>>) {
        this.verticals = value
    }

    @JvmName("eusbowxogcmhsqkf")
    public suspend fun verticals(vararg values: Output<String>) {
        this.verticals = Output.all(values.asList())
    }

    /**
     * @param values Industry verticals for the solution content item
     */
    @JvmName("qdlojxbhrmmgrugu")
    public suspend fun verticals(values: List<Output<String>>) {
        this.verticals = Output.all(values)
    }

    /**
     * @param value domain for the solution content item
     */
    @JvmName("xyikhddbqkpgwrui")
    public suspend fun domains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param values domain for the solution content item
     */
    @JvmName("lhpeswbvreeyxked")
    public suspend fun domains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value Industry verticals for the solution content item
     */
    @JvmName("wuwjaealmmwsiism")
    public suspend fun verticals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verticals = mapped
    }

    /**
     * @param values Industry verticals for the solution content item
     */
    @JvmName("lihkdjpwfcoifklv")
    public suspend fun verticals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verticals = mapped
    }

    internal fun build(): MetadataCategoriesArgs = MetadataCategoriesArgs(
        domains = domains,
        verticals = verticals,
    )
}
