@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.MetadataSourceArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.SourceKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The original source of the content item, where it comes from.
 * @property kind Source type of the content
 * @property name Name of the content source.  The repo name, solution name, LA workspace name etc.
 * @property sourceId ID of the content source.  The solution ID, workspace ID, etc
 */
public data class MetadataSourceArgs(
    public val kind: Output<Either<String, SourceKind>>,
    public val name: Output<String>? = null,
    public val sourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.MetadataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.MetadataSourceArgs =
        com.pulumi.azurenative.securityinsights.inputs.MetadataSourceArgs.builder()
            .kind(
                kind.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceId(sourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataSourceArgs].
 */
@PulumiTagMarker
public class MetadataSourceArgsBuilder internal constructor() {
    private var kind: Output<Either<String, SourceKind>>? = null

    private var name: Output<String>? = null

    private var sourceId: Output<String>? = null

    /**
     * @param value Source type of the content
     */
    @JvmName("nabwxhpjauvxraom")
    public suspend fun kind(`value`: Output<Either<String, SourceKind>>) {
        this.kind = value
    }

    /**
     * @param value Name of the content source.  The repo name, solution name, LA workspace name etc.
     */
    @JvmName("fjwnuujypwvrjuxs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the content source.  The solution ID, workspace ID, etc
     */
    @JvmName("rfaugwptkgicpchv")
    public suspend fun sourceId(`value`: Output<String>) {
        this.sourceId = value
    }

    /**
     * @param value Source type of the content
     */
    @JvmName("ghpdbiqvyqwrtlbs")
    public suspend fun kind(`value`: Either<String, SourceKind>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Source type of the content
     */
    @JvmName("skcaotopfokcjgdx")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Source type of the content
     */
    @JvmName("usqciuwdcpcjmkhr")
    public fun kind(`value`: SourceKind) {
        val toBeMapped = Either.ofRight<String, SourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the content source.  The repo name, solution name, LA workspace name etc.
     */
    @JvmName("hvrhxlieyyqccxrx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the content source.  The solution ID, workspace ID, etc
     */
    @JvmName("okggixrconmolbxj")
    public suspend fun sourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceId = mapped
    }

    internal fun build(): MetadataSourceArgs = MetadataSourceArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        name = name,
        sourceId = sourceId,
    )
}
