@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternTypeValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes threat kill chain phase entity
 * @property value Value of parsed pattern
 * @property valueType Type of the value
 */
public data class ThreatIntelligenceParsedPatternTypeValueArgs(
    public val `value`: Output<String>? = null,
    public val valueType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternTypeValueArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternTypeValueArgs =
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternTypeValueArgs.builder()
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .valueType(valueType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThreatIntelligenceParsedPatternTypeValueArgs].
 */
@PulumiTagMarker
public class ThreatIntelligenceParsedPatternTypeValueArgsBuilder internal constructor() {
    private var `value`: Output<String>? = null

    private var valueType: Output<String>? = null

    /**
     * @param value Value of parsed pattern
     */
    @JvmName("fxfwqsufimkjsegr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Type of the value
     */
    @JvmName("qiqsailgxypodwsc")
    public suspend fun valueType(`value`: Output<String>) {
        this.valueType = value
    }

    /**
     * @param value Value of parsed pattern
     */
    @JvmName("jafwxshgtiqkjvjs")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Type of the value
     */
    @JvmName("ficvasuchvslsjky")
    public suspend fun valueType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    internal fun build(): ThreatIntelligenceParsedPatternTypeValueArgs =
        ThreatIntelligenceParsedPatternTypeValueArgs(
            `value` = `value`,
            valueType = valueType,
        )
}
