@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents bookmark timeline item.
 * @property azureResourceId The bookmark azure resource id.
 * @property createdBy Describes a user that created the bookmark
 * @property displayName The bookmark display name.
 * @property endTimeUtc The bookmark end time.
 * @property eventTime The bookmark event time.
 * @property kind The entity query kind
 * Expected value is 'Bookmark'.
 * @property labels List of labels relevant to this bookmark
 * @property notes The notes of the bookmark
 * @property startTimeUtc The bookmark start time.
 */
public data class BookmarkTimelineItemResponse(
    public val azureResourceId: String,
    public val createdBy: UserInfoResponse? = null,
    public val displayName: String? = null,
    public val endTimeUtc: String? = null,
    public val eventTime: String? = null,
    public val kind: String,
    public val labels: List<String>? = null,
    public val notes: String? = null,
    public val startTimeUtc: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.BookmarkTimelineItemResponse):
            BookmarkTimelineItemResponse = BookmarkTimelineItemResponse(
            azureResourceId = javaType.azureResourceId(),
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            endTimeUtc = javaType.endTimeUtc().map({ args0 -> args0 }).orElse(null),
            eventTime = javaType.eventTime().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            labels = javaType.labels().map({ args0 -> args0 }),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            startTimeUtc = javaType.startTimeUtc().map({ args0 -> args0 }).orElse(null),
        )
    }
}
