@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource provider details include the required permissions for the user to create connections.
 * The user should have the required permissions(Read\Write, ..) in the specified scope ProviderPermissionsScope against the specified resource provider.
 * @property permissionsDisplayText Gets or sets the permissions description text.
 * @property provider Gets or sets the provider name.
 * @property providerDisplayName Gets or sets the permissions provider display name.
 * @property requiredPermissions Required permissions for the connector resource provider that define in ResourceProviders.
 * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
 * @property scope The scope on which the user should have permissions, in order to be able to create connections.
 */
public data class ConnectorDefinitionsResourceProviderResponse(
    public val permissionsDisplayText: String,
    public val provider: String,
    public val providerDisplayName: String,
    public val requiredPermissions: ResourceProviderRequiredPermissionsResponse,
    public val scope: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ConnectorDefinitionsResourceProviderResponse):
            ConnectorDefinitionsResourceProviderResponse = ConnectorDefinitionsResourceProviderResponse(
            permissionsDisplayText = javaType.permissionsDisplayText(),
            provider = javaType.provider(),
            providerDisplayName = javaType.providerDisplayName(),
            requiredPermissions = javaType.requiredPermissions().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.ResourceProviderRequiredPermissionsResponse.Companion.toKotlin(args0)
            }),
            scope = javaType.scope(),
        )
    }
}
