@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information regarding a deployment.
 * @property deployment Deployment information.
 * @property deploymentFetchStatus Status while fetching the last deployment.
 * @property message Additional details about the deployment that can be shown to the user.
 */
public data class DeploymentInfoResponse(
    public val deployment: DeploymentResponse? = null,
    public val deploymentFetchStatus: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.DeploymentInfoResponse):
            DeploymentInfoResponse = DeploymentInfoResponse(
            deployment = javaType.deployment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.DeploymentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentFetchStatus = javaType.deploymentFetchStatus().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
