@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A single field mapping of the mapped entity
 * @property columnName the column name to be mapped to the identifier
 * @property identifier the V3 identifier of the entity
 */
public data class FieldMappingResponse(
    public val columnName: String? = null,
    public val identifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.FieldMappingResponse):
            FieldMappingResponse = FieldMappingResponse(
            columnName = javaType.columnName().map({ args0 -> args0 }).orElse(null),
            identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
