@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents Amazon Web Services CloudTrail data connector.
 * @property awsRoleArn The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
 * @property dataTypes The available data types for the connector.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of the data connector
 * Expected value is 'AmazonWebServicesCloudTrail'.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAwsCloudTrailDataConnectorResult(
    public val awsRoleArn: String? = null,
    public val dataTypes: AwsCloudTrailDataConnectorDataTypesResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetAwsCloudTrailDataConnectorResult):
            GetAwsCloudTrailDataConnectorResult = GetAwsCloudTrailDataConnectorResult(
            awsRoleArn = javaType.awsRoleArn().map({ args0 -> args0 }).orElse(null),
            dataTypes = javaType.dataTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AwsCloudTrailDataConnectorDataTypesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
