@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Template resource definition.
 * @property author The creator of the content item.
 * @property categories Categories for the item
 * @property contentId Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
 * @property contentKind The kind of content the template is for.
 * @property contentSchemaVersion Schema version of the content. Can be used to distinguish between different flow based on the schema version
 * @property customVersion The custom version of the content. A optional free text
 * @property dependencies Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
 * @property displayName The display name of the template
 * @property etag Etag of the azure resource
 * @property firstPublishDate first publish date content item
 * @property icon the icon identifier. this id can later be fetched from the content metadata
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastPublishDate last publish date for the content item
 * @property mainTemplate The JSON of the ARM template to deploy active content
 * @property name The name of the resource
 * @property packageId the package Id contains this template
 * @property packageKind the packageKind of the package contains this template
 * @property packageName the name of the package contains this template
 * @property previewImages preview image file names. These will be taken from the solution artifacts
 * @property previewImagesDark preview image file names. These will be taken from the solution artifacts. used for dark theme support
 * @property providers Providers for the content item
 * @property source Source of the content.  This is where/how it was created.
 * @property support Support information for the template - type, name, contact information
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property threatAnalysisTactics the tactics the resource covers
 * @property threatAnalysisTechniques the techniques the resource covers, these have to be aligned with the tactics being used
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks
 */
public data class GetContentTemplateResult(
    public val author: MetadataAuthorResponse? = null,
    public val categories: MetadataCategoriesResponse? = null,
    public val contentId: String,
    public val contentKind: String,
    public val contentSchemaVersion: String? = null,
    public val customVersion: String? = null,
    public val dependencies: MetadataDependenciesResponse? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val firstPublishDate: String? = null,
    public val icon: String? = null,
    public val id: String,
    public val lastPublishDate: String? = null,
    public val mainTemplate: Any? = null,
    public val name: String,
    public val packageId: String,
    public val packageKind: String? = null,
    public val packageName: String? = null,
    public val previewImages: List<String>? = null,
    public val previewImagesDark: List<String>? = null,
    public val providers: List<String>? = null,
    public val source: MetadataSourceResponse,
    public val support: MetadataSupportResponse? = null,
    public val systemData: SystemDataResponse,
    public val threatAnalysisTactics: List<String>? = null,
    public val threatAnalysisTechniques: List<String>? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetContentTemplateResult):
            GetContentTemplateResult = GetContentTemplateResult(
            author = javaType.author().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            categories = javaType.categories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentId = javaType.contentId(),
            contentKind = javaType.contentKind(),
            contentSchemaVersion = javaType.contentSchemaVersion().map({ args0 -> args0 }).orElse(null),
            customVersion = javaType.customVersion().map({ args0 -> args0 }).orElse(null),
            dependencies = javaType.dependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            firstPublishDate = javaType.firstPublishDate().map({ args0 -> args0 }).orElse(null),
            icon = javaType.icon().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastPublishDate = javaType.lastPublishDate().map({ args0 -> args0 }).orElse(null),
            mainTemplate = javaType.mainTemplate().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            packageId = javaType.packageId(),
            packageKind = javaType.packageKind().map({ args0 -> args0 }).orElse(null),
            packageName = javaType.packageName().map({ args0 -> args0 }).orElse(null),
            previewImages = javaType.previewImages().map({ args0 -> args0 }),
            previewImagesDark = javaType.previewImagesDark().map({ args0 -> args0 }),
            providers = javaType.providers().map({ args0 -> args0 }),
            source = javaType.source().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse.Companion.toKotlin(args0)
            }),
            support = javaType.support().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            threatAnalysisTactics = javaType.threatAnalysisTactics().map({ args0 -> args0 }),
            threatAnalysisTechniques = javaType.threatAnalysisTechniques().map({ args0 -> args0 }),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
