@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents an incident in Azure Security Insights.
 * @property additionalData Additional data on the incident
 * @property classification The reason the incident was closed
 * @property classificationComment Describes the reason the incident was closed
 * @property classificationReason The classification reason the incident was closed with
 * @property createdTimeUtc The time the incident was created
 * @property description The description of the incident
 * @property etag Etag of the azure resource
 * @property firstActivityTimeUtc The time of the first activity in the incident
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property incidentNumber A sequential number
 * @property incidentUrl The deep-link url to the incident in Azure portal
 * @property labels List of labels relevant to this incident
 * @property lastActivityTimeUtc The time of the last activity in the incident
 * @property lastModifiedTimeUtc The last time the incident was updated
 * @property name The name of the resource
 * @property owner Describes a user that the incident is assigned to
 * @property providerIncidentId The incident ID assigned by the incident provider
 * @property providerName The name of the source provider that generated the incident
 * @property relatedAnalyticRuleIds List of resource ids of Analytic rules related to the incident
 * @property severity The severity of the incident
 * @property status The status of the incident
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property title The title of the incident
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIncidentResult(
    public val additionalData: IncidentAdditionalDataResponse,
    public val classification: String? = null,
    public val classificationComment: String? = null,
    public val classificationReason: String? = null,
    public val createdTimeUtc: String,
    public val description: String? = null,
    public val etag: String? = null,
    public val firstActivityTimeUtc: String? = null,
    public val id: String,
    public val incidentNumber: Int,
    public val incidentUrl: String,
    public val labels: List<IncidentLabelResponse>? = null,
    public val lastActivityTimeUtc: String? = null,
    public val lastModifiedTimeUtc: String,
    public val name: String,
    public val owner: IncidentOwnerInfoResponse? = null,
    public val providerIncidentId: String,
    public val providerName: String,
    public val relatedAnalyticRuleIds: List<String>,
    public val severity: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val title: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetIncidentResult):
            GetIncidentResult = GetIncidentResult(
            additionalData = javaType.additionalData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentAdditionalDataResponse.Companion.toKotlin(args0)
            }),
            classification = javaType.classification().map({ args0 -> args0 }).orElse(null),
            classificationComment = javaType.classificationComment().map({ args0 -> args0 }).orElse(null),
            classificationReason = javaType.classificationReason().map({ args0 -> args0 }).orElse(null),
            createdTimeUtc = javaType.createdTimeUtc(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            firstActivityTimeUtc = javaType.firstActivityTimeUtc().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            incidentNumber = javaType.incidentNumber(),
            incidentUrl = javaType.incidentUrl(),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentLabelResponse.Companion.toKotlin(args0)
                })
            }),
            lastActivityTimeUtc = javaType.lastActivityTimeUtc().map({ args0 -> args0 }).orElse(null),
            lastModifiedTimeUtc = javaType.lastModifiedTimeUtc(),
            name = javaType.name(),
            owner = javaType.owner().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentOwnerInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            providerIncidentId = javaType.providerIncidentId(),
            providerName = javaType.providerName(),
            relatedAnalyticRuleIds = javaType.relatedAnalyticRuleIds().map({ args0 -> args0 }),
            severity = javaType.severity(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            title = javaType.title(),
            type = javaType.type(),
        )
    }
}
