@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents MicrosoftSecurityIncidentCreation rule.
 * @property alertRuleTemplateName The Name of the alert rule template used to create this rule.
 * @property description The description of the alert rule.
 * @property displayName The display name for alerts created by this alert rule.
 * @property displayNamesExcludeFilter the alerts' displayNames on which the cases will not be generated
 * @property displayNamesFilter the alerts' displayNames on which the cases will be generated
 * @property enabled Determines whether this alert rule is enabled or disabled.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of the alert rule
 * Expected value is 'MicrosoftSecurityIncidentCreation'.
 * @property lastModifiedUtc The last time that this alert has been modified.
 * @property name The name of the resource
 * @property productFilter The alerts' productName on which the cases will be generated
 * @property severitiesFilter the alerts' severities on which the cases will be generated
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMicrosoftSecurityIncidentCreationAlertRuleResult(
    public val alertRuleTemplateName: String? = null,
    public val description: String? = null,
    public val displayName: String,
    public val displayNamesExcludeFilter: List<String>? = null,
    public val displayNamesFilter: List<String>? = null,
    public val enabled: Boolean,
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val lastModifiedUtc: String,
    public val name: String,
    public val productFilter: String,
    public val severitiesFilter: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetMicrosoftSecurityIncidentCreationAlertRuleResult):
            GetMicrosoftSecurityIncidentCreationAlertRuleResult =
            GetMicrosoftSecurityIncidentCreationAlertRuleResult(
                alertRuleTemplateName = javaType.alertRuleTemplateName().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName(),
                displayNamesExcludeFilter = javaType.displayNamesExcludeFilter().map({ args0 -> args0 }),
                displayNamesFilter = javaType.displayNamesFilter().map({ args0 -> args0 }),
                enabled = javaType.enabled(),
                etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                kind = javaType.kind(),
                lastModifiedUtc = javaType.lastModifiedUtc(),
                name = javaType.name(),
                productFilter = javaType.productFilter(),
                severitiesFilter = javaType.severitiesFilter().map({ args0 -> args0 }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
