@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a SourceControl in Azure Security Insights.
 * @property contentTypes Array of source control content types.
 * @property description A description of the source control
 * @property displayName The display name of the source control
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastDeploymentInfo Information regarding the latest deployment for the source control.
 * @property name The name of the resource
 * @property repoType The repository type of the source control
 * @property repository Repository metadata.
 * @property repositoryResourceInfo Information regarding the resources created in user's repository.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version The version number associated with the source control
 */
public data class GetSourceControlResult(
    public val contentTypes: List<String>,
    public val description: String? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val id: String,
    public val lastDeploymentInfo: DeploymentInfoResponse? = null,
    public val name: String,
    public val repoType: String,
    public val repository: RepositoryResponse,
    public val repositoryResourceInfo: RepositoryResourceInfoResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetSourceControlResult):
            GetSourceControlResult = GetSourceControlResult(
            contentTypes = javaType.contentTypes().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastDeploymentInfo = javaType.lastDeploymentInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.DeploymentInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            repoType = javaType.repoType(),
            repository = javaType.repository().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.RepositoryResponse.Companion.toKotlin(args0)
            }),
            repositoryResourceInfo = javaType.repositoryResourceInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.RepositoryResourceInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
