@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The workspace manager member
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property targetWorkspaceResourceId Fully qualified resource ID of the target Sentinel workspace joining the given Sentinel workspace manager
 * @property targetWorkspaceTenantId Tenant id of the target Sentinel workspace joining the given Sentinel workspace manager
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceManagerMemberResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val targetWorkspaceResourceId: String,
    public val targetWorkspaceTenantId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetWorkspaceManagerMemberResult):
            GetWorkspaceManagerMemberResult = GetWorkspaceManagerMemberResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetWorkspaceResourceId = javaType.targetWorkspaceResourceId(),
            targetWorkspaceTenantId = javaType.targetWorkspaceTenantId(),
            type = javaType.type(),
        )
    }
}
