@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resources created in GitHub repository.
 * @property appInstallationId GitHub application installation id.
 */
public data class GitHubResourceInfoResponse(
    public val appInstallationId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GitHubResourceInfoResponse):
            GitHubResourceInfoResponse = GitHubResourceInfoResponse(
            appInstallationId = javaType.appInstallationId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
