@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an incident label
 * @property labelName The name of the label
 * @property labelType The type of the label
 */
public data class IncidentLabelResponse(
    public val labelName: String,
    public val labelType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.IncidentLabelResponse):
            IncidentLabelResponse = IncidentLabelResponse(
            labelName = javaType.labelName(),
            labelType = javaType.labelType(),
        )
    }
}
