@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information on the user an incident is assigned to
 * @property assignedTo The name of the user the incident is assigned to.
 * @property email The email of the user the incident is assigned to.
 * @property objectId The object id of the user the incident is assigned to.
 * @property ownerType The type of the owner the incident is assigned to.
 * @property userPrincipalName The user principal name of the user the incident is assigned to.
 */
public data class IncidentOwnerInfoResponse(
    public val assignedTo: String? = null,
    public val email: String? = null,
    public val objectId: String? = null,
    public val ownerType: String? = null,
    public val userPrincipalName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.IncidentOwnerInfoResponse):
            IncidentOwnerInfoResponse = IncidentOwnerInfoResponse(
            assignedTo = javaType.assignedTo().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            ownerType = javaType.ownerType().map({ args0 -> args0 }).orElse(null),
            userPrincipalName = javaType.userPrincipalName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
