@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Support information for the content item.
 * @property email Email of support contact
 * @property link Link for support help, like to support page to open a ticket etc.
 * @property name Name of the support contact. Company or person.
 * @property tier Type of support for content item
 */
public data class MetadataSupportResponse(
    public val email: String? = null,
    public val link: String? = null,
    public val name: String? = null,
    public val tier: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.MetadataSupportResponse):
            MetadataSupportResponse = MetadataSupportResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            link = javaType.link().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier(),
        )
    }
}
