@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an automation rule condition that evaluates an array property's value change
 * @property conditionProperties
 * @property conditionType
 * Expected value is 'PropertyArrayChanged'.
 */
public data class PropertyArrayChangedConditionPropertiesResponse(
    public val conditionProperties: AutomationRulePropertyArrayChangedValuesConditionResponse? = null,
    public val conditionType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.PropertyArrayChangedConditionPropertiesResponse):
            PropertyArrayChangedConditionPropertiesResponse =
            PropertyArrayChangedConditionPropertiesResponse(
                conditionProperties = javaType.conditionProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRulePropertyArrayChangedValuesConditionResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                conditionType = javaType.conditionType(),
            )
    }
}
