@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.SubscriptionArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.EntityStatus
import com.pulumi.azurenative.servicebus.kotlin.inputs.SBClientAffinePropertiesArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.SBClientAffinePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of subscription resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### SubscriptionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscription = new AzureNative.ServiceBus.Subscription("subscription", new()
 *     {
 *         EnableBatchedOperations = true,
 *         NamespaceName = "sdk-Namespace-1349",
 *         ResourceGroupName = "ResourceGroup",
 *         SubscriptionName = "sdk-Subscriptions-2178",
 *         TopicName = "sdk-Topics-8740",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewSubscription(ctx, "subscription", &servicebus.SubscriptionArgs{
 * 			EnableBatchedOperations: pulumi.Bool(true),
 * 			NamespaceName:           pulumi.String("sdk-Namespace-1349"),
 * 			ResourceGroupName:       pulumi.String("ResourceGroup"),
 * 			SubscriptionName:        pulumi.String("sdk-Subscriptions-2178"),
 * 			TopicName:               pulumi.String("sdk-Topics-8740"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Subscription;
 * import com.pulumi.azurenative.servicebus.SubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscription = new Subscription("subscription", SubscriptionArgs.builder()
 *             .enableBatchedOperations(true)
 *             .namespaceName("sdk-Namespace-1349")
 *             .resourceGroupName("ResourceGroup")
 *             .subscriptionName("sdk-Subscriptions-2178")
 *             .topicName("sdk-Topics-8740")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Subscription sdk-Subscriptions-2178 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}
 * ```
 * @property autoDeleteOnIdle ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
 * @property clientAffineProperties Properties specific to client affine subscriptions.
 * @property deadLetteringOnFilterEvaluationExceptions Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
 * @property deadLetteringOnMessageExpiration Value that indicates whether a subscription has dead letter support when a message expires.
 * @property defaultMessageTimeToLive ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
 * @property duplicateDetectionHistoryTimeWindow ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
 * @property enableBatchedOperations Value that indicates whether server-side batched operations are enabled.
 * @property forwardDeadLetteredMessagesTo Queue/Topic name to forward the Dead Letter message
 * @property forwardTo Queue/Topic name to forward the messages
 * @property isClientAffine Value that indicates whether the subscription has an affinity to the client id.
 * @property lockDuration ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
 * @property maxDeliveryCount Number of maximum deliveries.
 * @property namespaceName The namespace name
 * @property requiresSession Value indicating if a subscription supports the concept of sessions.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property status Enumerates the possible values for the status of a messaging entity.
 * @property subscriptionName The subscription name.
 * @property topicName The topic name.
 */
public data class SubscriptionArgs(
    public val autoDeleteOnIdle: Output<String>? = null,
    public val clientAffineProperties: Output<SBClientAffinePropertiesArgs>? = null,
    public val deadLetteringOnFilterEvaluationExceptions: Output<Boolean>? = null,
    public val deadLetteringOnMessageExpiration: Output<Boolean>? = null,
    public val defaultMessageTimeToLive: Output<String>? = null,
    public val duplicateDetectionHistoryTimeWindow: Output<String>? = null,
    public val enableBatchedOperations: Output<Boolean>? = null,
    public val forwardDeadLetteredMessagesTo: Output<String>? = null,
    public val forwardTo: Output<String>? = null,
    public val isClientAffine: Output<Boolean>? = null,
    public val lockDuration: Output<String>? = null,
    public val maxDeliveryCount: Output<Int>? = null,
    public val namespaceName: Output<String>? = null,
    public val requiresSession: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<EntityStatus>? = null,
    public val subscriptionName: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.SubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.SubscriptionArgs =
        com.pulumi.azurenative.servicebus.SubscriptionArgs.builder()
            .autoDeleteOnIdle(autoDeleteOnIdle?.applyValue({ args0 -> args0 }))
            .clientAffineProperties(
                clientAffineProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deadLetteringOnFilterEvaluationExceptions(
                deadLetteringOnFilterEvaluationExceptions?.applyValue({ args0 ->
                    args0
                }),
            )
            .deadLetteringOnMessageExpiration(deadLetteringOnMessageExpiration?.applyValue({ args0 -> args0 }))
            .defaultMessageTimeToLive(defaultMessageTimeToLive?.applyValue({ args0 -> args0 }))
            .duplicateDetectionHistoryTimeWindow(
                duplicateDetectionHistoryTimeWindow?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableBatchedOperations(enableBatchedOperations?.applyValue({ args0 -> args0 }))
            .forwardDeadLetteredMessagesTo(forwardDeadLetteredMessagesTo?.applyValue({ args0 -> args0 }))
            .forwardTo(forwardTo?.applyValue({ args0 -> args0 }))
            .isClientAffine(isClientAffine?.applyValue({ args0 -> args0 }))
            .lockDuration(lockDuration?.applyValue({ args0 -> args0 }))
            .maxDeliveryCount(maxDeliveryCount?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .requiresSession(requiresSession?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriptionName(subscriptionName?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionArgs].
 */
@PulumiTagMarker
public class SubscriptionArgsBuilder internal constructor() {
    private var autoDeleteOnIdle: Output<String>? = null

    private var clientAffineProperties: Output<SBClientAffinePropertiesArgs>? = null

    private var deadLetteringOnFilterEvaluationExceptions: Output<Boolean>? = null

    private var deadLetteringOnMessageExpiration: Output<Boolean>? = null

    private var defaultMessageTimeToLive: Output<String>? = null

    private var duplicateDetectionHistoryTimeWindow: Output<String>? = null

    private var enableBatchedOperations: Output<Boolean>? = null

    private var forwardDeadLetteredMessagesTo: Output<String>? = null

    private var forwardTo: Output<String>? = null

    private var isClientAffine: Output<Boolean>? = null

    private var lockDuration: Output<String>? = null

    private var maxDeliveryCount: Output<Int>? = null

    private var namespaceName: Output<String>? = null

    private var requiresSession: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<EntityStatus>? = null

    private var subscriptionName: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
     */
    @JvmName("uhrooakvdknwsubo")
    public suspend fun autoDeleteOnIdle(`value`: Output<String>) {
        this.autoDeleteOnIdle = value
    }

    /**
     * @param value Properties specific to client affine subscriptions.
     */
    @JvmName("dxsmoaqububsdhdx")
    public suspend fun clientAffineProperties(`value`: Output<SBClientAffinePropertiesArgs>) {
        this.clientAffineProperties = value
    }

    /**
     * @param value Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
     */
    @JvmName("uhvnsmxyovhyhtja")
    public suspend fun deadLetteringOnFilterEvaluationExceptions(`value`: Output<Boolean>) {
        this.deadLetteringOnFilterEvaluationExceptions = value
    }

    /**
     * @param value Value that indicates whether a subscription has dead letter support when a message expires.
     */
    @JvmName("rurwbqexpppgpiss")
    public suspend fun deadLetteringOnMessageExpiration(`value`: Output<Boolean>) {
        this.deadLetteringOnMessageExpiration = value
    }

    /**
     * @param value ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    @JvmName("pcejusarcpfoyrcd")
    public suspend fun defaultMessageTimeToLive(`value`: Output<String>) {
        this.defaultMessageTimeToLive = value
    }

    /**
     * @param value ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    @JvmName("hyokcmirmumjagji")
    public suspend fun duplicateDetectionHistoryTimeWindow(`value`: Output<String>) {
        this.duplicateDetectionHistoryTimeWindow = value
    }

    /**
     * @param value Value that indicates whether server-side batched operations are enabled.
     */
    @JvmName("ontnpxnfydtjomsc")
    public suspend fun enableBatchedOperations(`value`: Output<Boolean>) {
        this.enableBatchedOperations = value
    }

    /**
     * @param value Queue/Topic name to forward the Dead Letter message
     */
    @JvmName("udngbscpqcwvxqnq")
    public suspend fun forwardDeadLetteredMessagesTo(`value`: Output<String>) {
        this.forwardDeadLetteredMessagesTo = value
    }

    /**
     * @param value Queue/Topic name to forward the messages
     */
    @JvmName("hlctoiqkdoscsmkq")
    public suspend fun forwardTo(`value`: Output<String>) {
        this.forwardTo = value
    }

    /**
     * @param value Value that indicates whether the subscription has an affinity to the client id.
     */
    @JvmName("dxppbdyxkbpkhkcu")
    public suspend fun isClientAffine(`value`: Output<Boolean>) {
        this.isClientAffine = value
    }

    /**
     * @param value ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
     */
    @JvmName("ukxrewxanfcvqotd")
    public suspend fun lockDuration(`value`: Output<String>) {
        this.lockDuration = value
    }

    /**
     * @param value Number of maximum deliveries.
     */
    @JvmName("ordiwqvhnhcbmmhd")
    public suspend fun maxDeliveryCount(`value`: Output<Int>) {
        this.maxDeliveryCount = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ditahvxrpwfgnbkd")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Value indicating if a subscription supports the concept of sessions.
     */
    @JvmName("fbdqovevoiboootu")
    public suspend fun requiresSession(`value`: Output<Boolean>) {
        this.requiresSession = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("odcrjiehfujvdrqo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Enumerates the possible values for the status of a messaging entity.
     */
    @JvmName("vbhspbnseqijmmrg")
    public suspend fun status(`value`: Output<EntityStatus>) {
        this.status = value
    }

    /**
     * @param value The subscription name.
     */
    @JvmName("vqakaxspfmxrbjut")
    public suspend fun subscriptionName(`value`: Output<String>) {
        this.subscriptionName = value
    }

    /**
     * @param value The topic name.
     */
    @JvmName("wrbeoymyemrmmtqy")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
     */
    @JvmName("etdpnnotxayeqyxg")
    public suspend fun autoDeleteOnIdle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteOnIdle = mapped
    }

    /**
     * @param value Properties specific to client affine subscriptions.
     */
    @JvmName("xqvptmxhtxcmiuwx")
    public suspend fun clientAffineProperties(`value`: SBClientAffinePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAffineProperties = mapped
    }

    /**
     * @param argument Properties specific to client affine subscriptions.
     */
    @JvmName("gnjoswfbiyilgnap")
    public suspend
    fun clientAffineProperties(argument: suspend SBClientAffinePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SBClientAffinePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientAffineProperties = mapped
    }

    /**
     * @param value Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
     */
    @JvmName("bhhlrdjhesivlmoh")
    public suspend fun deadLetteringOnFilterEvaluationExceptions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetteringOnFilterEvaluationExceptions = mapped
    }

    /**
     * @param value Value that indicates whether a subscription has dead letter support when a message expires.
     */
    @JvmName("rxfctgfnntjfvwvl")
    public suspend fun deadLetteringOnMessageExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetteringOnMessageExpiration = mapped
    }

    /**
     * @param value ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    @JvmName("yrowedykcmwlaybb")
    public suspend fun defaultMessageTimeToLive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMessageTimeToLive = mapped
    }

    /**
     * @param value ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    @JvmName("drqukrrfqmfgxaeh")
    public suspend fun duplicateDetectionHistoryTimeWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duplicateDetectionHistoryTimeWindow = mapped
    }

    /**
     * @param value Value that indicates whether server-side batched operations are enabled.
     */
    @JvmName("tkyswwcmtwmthpws")
    public suspend fun enableBatchedOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBatchedOperations = mapped
    }

    /**
     * @param value Queue/Topic name to forward the Dead Letter message
     */
    @JvmName("tonmoindxkfwtmig")
    public suspend fun forwardDeadLetteredMessagesTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardDeadLetteredMessagesTo = mapped
    }

    /**
     * @param value Queue/Topic name to forward the messages
     */
    @JvmName("rwprkslkprojrjti")
    public suspend fun forwardTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardTo = mapped
    }

    /**
     * @param value Value that indicates whether the subscription has an affinity to the client id.
     */
    @JvmName("fjwobuyqastsvsyw")
    public suspend fun isClientAffine(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isClientAffine = mapped
    }

    /**
     * @param value ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
     */
    @JvmName("ojtitsaryqhisest")
    public suspend fun lockDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockDuration = mapped
    }

    /**
     * @param value Number of maximum deliveries.
     */
    @JvmName("korylchkcljgxofv")
    public suspend fun maxDeliveryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryCount = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("vectmaakfqgpsolg")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Value indicating if a subscription supports the concept of sessions.
     */
    @JvmName("pqqaxviqppspjnxd")
    public suspend fun requiresSession(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresSession = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("nbcfwnwlrpxueapx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Enumerates the possible values for the status of a messaging entity.
     */
    @JvmName("qyfnuxjkphtrfpqi")
    public suspend fun status(`value`: EntityStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The subscription name.
     */
    @JvmName("jpkhkilodiilarjv")
    public suspend fun subscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionName = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("qvsbncrbxogilpew")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): SubscriptionArgs = SubscriptionArgs(
        autoDeleteOnIdle = autoDeleteOnIdle,
        clientAffineProperties = clientAffineProperties,
        deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions,
        deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration,
        defaultMessageTimeToLive = defaultMessageTimeToLive,
        duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow,
        enableBatchedOperations = enableBatchedOperations,
        forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo,
        forwardTo = forwardTo,
        isClientAffine = isClientAffine,
        lockDuration = lockDuration,
        maxDeliveryCount = maxDeliveryCount,
        namespaceName = namespaceName,
        requiresSession = requiresSession,
        resourceGroupName = resourceGroupName,
        status = status,
        subscriptionName = subscriptionName,
        topicName = topicName,
    )
}
