@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.TopicArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.EntityStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of topic resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### TopicCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AzureNative.ServiceBus.Topic("topic", new()
 *     {
 *         EnableExpress = true,
 *         NamespaceName = "sdk-Namespace-1617",
 *         ResourceGroupName = "ArunMonocle",
 *         TopicName = "sdk-Topics-5488",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewTopic(ctx, "topic", &servicebus.TopicArgs{
 * 			EnableExpress:     pulumi.Bool(true),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1617"),
 * 			ResourceGroupName: pulumi.String("ArunMonocle"),
 * 			TopicName:         pulumi.String("sdk-Topics-5488"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Topic;
 * import com.pulumi.azurenative.servicebus.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .enableExpress(true)
 *             .namespaceName("sdk-Namespace-1617")
 *             .resourceGroupName("ArunMonocle")
 *             .topicName("sdk-Topics-5488")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Topic sdk-Topics-5488 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}
 * ```
 * @property autoDeleteOnIdle ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
 * @property defaultMessageTimeToLive ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
 * @property duplicateDetectionHistoryTimeWindow ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
 * @property enableBatchedOperations Value that indicates whether server-side batched operations are enabled.
 * @property enableExpress Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
 * @property enablePartitioning Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
 * @property maxMessageSizeInKilobytes Maximum size (in KB) of the message payload that can be accepted by the topic. This property is only used in Premium today and default is 1024.
 * @property maxSizeInMegabytes Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
 * @property namespaceName The namespace name
 * @property requiresDuplicateDetection Value indicating if this topic requires duplicate detection.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property status Enumerates the possible values for the status of a messaging entity.
 * @property supportOrdering Value that indicates whether the topic supports ordering.
 * @property topicName The topic name.
 */
public data class TopicArgs(
    public val autoDeleteOnIdle: Output<String>? = null,
    public val defaultMessageTimeToLive: Output<String>? = null,
    public val duplicateDetectionHistoryTimeWindow: Output<String>? = null,
    public val enableBatchedOperations: Output<Boolean>? = null,
    public val enableExpress: Output<Boolean>? = null,
    public val enablePartitioning: Output<Boolean>? = null,
    public val maxMessageSizeInKilobytes: Output<Double>? = null,
    public val maxSizeInMegabytes: Output<Int>? = null,
    public val namespaceName: Output<String>? = null,
    public val requiresDuplicateDetection: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<EntityStatus>? = null,
    public val supportOrdering: Output<Boolean>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.TopicArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.TopicArgs =
        com.pulumi.azurenative.servicebus.TopicArgs.builder()
            .autoDeleteOnIdle(autoDeleteOnIdle?.applyValue({ args0 -> args0 }))
            .defaultMessageTimeToLive(defaultMessageTimeToLive?.applyValue({ args0 -> args0 }))
            .duplicateDetectionHistoryTimeWindow(
                duplicateDetectionHistoryTimeWindow?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableBatchedOperations(enableBatchedOperations?.applyValue({ args0 -> args0 }))
            .enableExpress(enableExpress?.applyValue({ args0 -> args0 }))
            .enablePartitioning(enablePartitioning?.applyValue({ args0 -> args0 }))
            .maxMessageSizeInKilobytes(maxMessageSizeInKilobytes?.applyValue({ args0 -> args0 }))
            .maxSizeInMegabytes(maxSizeInMegabytes?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .requiresDuplicateDetection(requiresDuplicateDetection?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .supportOrdering(supportOrdering?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var autoDeleteOnIdle: Output<String>? = null

    private var defaultMessageTimeToLive: Output<String>? = null

    private var duplicateDetectionHistoryTimeWindow: Output<String>? = null

    private var enableBatchedOperations: Output<Boolean>? = null

    private var enableExpress: Output<Boolean>? = null

    private var enablePartitioning: Output<Boolean>? = null

    private var maxMessageSizeInKilobytes: Output<Double>? = null

    private var maxSizeInMegabytes: Output<Int>? = null

    private var namespaceName: Output<String>? = null

    private var requiresDuplicateDetection: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<EntityStatus>? = null

    private var supportOrdering: Output<Boolean>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
     */
    @JvmName("qifeaunjjrxdhuek")
    public suspend fun autoDeleteOnIdle(`value`: Output<String>) {
        this.autoDeleteOnIdle = value
    }

    /**
     * @param value ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    @JvmName("fhscyrgaxsiyakpu")
    public suspend fun defaultMessageTimeToLive(`value`: Output<String>) {
        this.defaultMessageTimeToLive = value
    }

    /**
     * @param value ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    @JvmName("xgqirvkkhrehdaqd")
    public suspend fun duplicateDetectionHistoryTimeWindow(`value`: Output<String>) {
        this.duplicateDetectionHistoryTimeWindow = value
    }

    /**
     * @param value Value that indicates whether server-side batched operations are enabled.
     */
    @JvmName("vndmggiknwyaaqir")
    public suspend fun enableBatchedOperations(`value`: Output<Boolean>) {
        this.enableBatchedOperations = value
    }

    /**
     * @param value Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
     */
    @JvmName("hjvkwbhcitkewlas")
    public suspend fun enableExpress(`value`: Output<Boolean>) {
        this.enableExpress = value
    }

    /**
     * @param value Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
     */
    @JvmName("xhqhcwtsnuvurywo")
    public suspend fun enablePartitioning(`value`: Output<Boolean>) {
        this.enablePartitioning = value
    }

    /**
     * @param value Maximum size (in KB) of the message payload that can be accepted by the topic. This property is only used in Premium today and default is 1024.
     */
    @JvmName("viovfvgsikvoutbn")
    public suspend fun maxMessageSizeInKilobytes(`value`: Output<Double>) {
        this.maxMessageSizeInKilobytes = value
    }

    /**
     * @param value Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
     */
    @JvmName("mkxkefpntdnnuymc")
    public suspend fun maxSizeInMegabytes(`value`: Output<Int>) {
        this.maxSizeInMegabytes = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ltarnusmjryvcexu")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Value indicating if this topic requires duplicate detection.
     */
    @JvmName("hipdevafmapknqhg")
    public suspend fun requiresDuplicateDetection(`value`: Output<Boolean>) {
        this.requiresDuplicateDetection = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("jkcawpjwupxfycng")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Enumerates the possible values for the status of a messaging entity.
     */
    @JvmName("okbfpclsvqmiwapq")
    public suspend fun status(`value`: Output<EntityStatus>) {
        this.status = value
    }

    /**
     * @param value Value that indicates whether the topic supports ordering.
     */
    @JvmName("xqxahjvohcmwbxji")
    public suspend fun supportOrdering(`value`: Output<Boolean>) {
        this.supportOrdering = value
    }

    /**
     * @param value The topic name.
     */
    @JvmName("scrbaavxvxkiloho")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
     */
    @JvmName("jhfqaovylofhwbns")
    public suspend fun autoDeleteOnIdle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteOnIdle = mapped
    }

    /**
     * @param value ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    @JvmName("ejkvoegmoviikrss")
    public suspend fun defaultMessageTimeToLive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMessageTimeToLive = mapped
    }

    /**
     * @param value ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    @JvmName("kcbixwffprfvkpwb")
    public suspend fun duplicateDetectionHistoryTimeWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duplicateDetectionHistoryTimeWindow = mapped
    }

    /**
     * @param value Value that indicates whether server-side batched operations are enabled.
     */
    @JvmName("apoubyssyfjsoiok")
    public suspend fun enableBatchedOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBatchedOperations = mapped
    }

    /**
     * @param value Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
     */
    @JvmName("tpgrhjulebvgjwrr")
    public suspend fun enableExpress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExpress = mapped
    }

    /**
     * @param value Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
     */
    @JvmName("bikdeyxjckjtlkgi")
    public suspend fun enablePartitioning(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitioning = mapped
    }

    /**
     * @param value Maximum size (in KB) of the message payload that can be accepted by the topic. This property is only used in Premium today and default is 1024.
     */
    @JvmName("mcujvudokxoojgyh")
    public suspend fun maxMessageSizeInKilobytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMessageSizeInKilobytes = mapped
    }

    /**
     * @param value Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
     */
    @JvmName("awbwlrwrtcvvklaf")
    public suspend fun maxSizeInMegabytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSizeInMegabytes = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("tlboplgiaqovbcul")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Value indicating if this topic requires duplicate detection.
     */
    @JvmName("ekwelfyoyjrtttpl")
    public suspend fun requiresDuplicateDetection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresDuplicateDetection = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("nvhdxdimxmrghsli")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Enumerates the possible values for the status of a messaging entity.
     */
    @JvmName("ktavrvnpuyahabnp")
    public suspend fun status(`value`: EntityStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Value that indicates whether the topic supports ordering.
     */
    @JvmName("ioquiathjnvfnicb")
    public suspend fun supportOrdering(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportOrdering = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("uhcqdndvluxxuawh")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        autoDeleteOnIdle = autoDeleteOnIdle,
        defaultMessageTimeToLive = defaultMessageTimeToLive,
        duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow,
        enableBatchedOperations = enableBatchedOperations,
        enableExpress = enableExpress,
        enablePartitioning = enablePartitioning,
        maxMessageSizeInKilobytes = maxMessageSizeInKilobytes,
        maxSizeInMegabytes = maxSizeInMegabytes,
        namespaceName = namespaceName,
        requiresDuplicateDetection = requiresDuplicateDetection,
        resourceGroupName = resourceGroupName,
        status = status,
        supportOrdering = supportOrdering,
        topicName = topicName,
    )
}
