@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if traffic is allowed over public network. By default it is enabled.
 */
public enum class PublicNetworkAccessFlag(
    public val javaValue: com.pulumi.azurenative.servicebus.enums.PublicNetworkAccessFlag,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.enums.PublicNetworkAccessFlag> {
    Enabled(com.pulumi.azurenative.servicebus.enums.PublicNetworkAccessFlag.Enabled),
    Disabled(com.pulumi.azurenative.servicebus.enums.PublicNetworkAccessFlag.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.servicebus.enums.PublicNetworkAccessFlag = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.enums.PublicNetworkAccessFlag):
            PublicNetworkAccessFlag =
            PublicNetworkAccessFlag.values().first { it.javaValue == javaType }
    }
}
