@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The billing tier of this particular SKU.
 */
public enum class SkuTier(
    public val javaValue: com.pulumi.azurenative.servicebus.enums.SkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.enums.SkuTier> {
    Basic(com.pulumi.azurenative.servicebus.enums.SkuTier.Basic),
    Standard(com.pulumi.azurenative.servicebus.enums.SkuTier.Standard),
    Premium(com.pulumi.azurenative.servicebus.enums.SkuTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.servicebus.enums.SkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.enums.SkuTier): SkuTier =
            SkuTier.values().first { it.javaValue == javaType }
    }
}
