@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.ConnectionStateArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.PrivateLinkConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ConnectionState information.
 * @property description Description of the connection state.
 * @property status Status of the connection.
 */
public data class ConnectionStateArgs(
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PrivateLinkConnectionStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.ConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.ConnectionStateArgs =
        com.pulumi.azurenative.servicebus.inputs.ConnectionStateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionStateArgs].
 */
@PulumiTagMarker
public class ConnectionStateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateLinkConnectionStatus>>? = null

    /**
     * @param value Description of the connection state.
     */
    @JvmName("duviwtuyytwyhxtn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("rwamiqukwsnsdkst")
    public suspend fun status(`value`: Output<Either<String, PrivateLinkConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Description of the connection state.
     */
    @JvmName("pevxnmjodmahpbrb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("wgbpdevdhhctbftg")
    public suspend fun status(`value`: Either<String, PrivateLinkConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("luutbriwjmrribif")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("hpyjebemflddngks")
    public fun status(`value`: PrivateLinkConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ConnectionStateArgs = ConnectionStateArgs(
        description = description,
        status = status,
    )
}
