@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetNamespaceIpFilterRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipFilterRuleName The IP Filter Rule name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetNamespaceIpFilterRulePlainArgs(
    public val ipFilterRuleName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetNamespaceIpFilterRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetNamespaceIpFilterRulePlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetNamespaceIpFilterRulePlainArgs.builder()
            .ipFilterRuleName(ipFilterRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespaceIpFilterRulePlainArgs].
 */
@PulumiTagMarker
public class GetNamespaceIpFilterRulePlainArgsBuilder internal constructor() {
    private var ipFilterRuleName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The IP Filter Rule name.
     */
    @JvmName("bpodqsebacuthdef")
    public suspend fun ipFilterRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipFilterRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("wkhoadmmlcgtdxbv")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("timntdyqqtcuqija")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNamespaceIpFilterRulePlainArgs = GetNamespaceIpFilterRulePlainArgs(
        ipFilterRuleName = ipFilterRuleName ?: throw PulumiNullFieldException("ipFilterRuleName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
