@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetNamespaceVirtualNetworkRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property virtualNetworkRuleName The Virtual Network Rule name.
 */
public data class GetNamespaceVirtualNetworkRulePlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val virtualNetworkRuleName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetNamespaceVirtualNetworkRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicebus.inputs.GetNamespaceVirtualNetworkRulePlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetNamespaceVirtualNetworkRulePlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkRuleName(virtualNetworkRuleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespaceVirtualNetworkRulePlainArgs].
 */
@PulumiTagMarker
public class GetNamespaceVirtualNetworkRulePlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkRuleName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("gmfcvcxakjtcncbb")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("unussridncuwiyyn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Virtual Network Rule name.
     */
    @JvmName("mbxlxdmkpfnlwegt")
    public suspend fun virtualNetworkRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkRuleName = mapped
    }

    internal fun build(): GetNamespaceVirtualNetworkRulePlainArgs =
        GetNamespaceVirtualNetworkRulePlainArgs(
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkRuleName = virtualNetworkRuleName ?: throw
                PulumiNullFieldException("virtualNetworkRuleName"),
        )
}
