@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetTopicAuthorizationRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property topicName The topic name.
 */
public data class GetTopicAuthorizationRulePlainArgs(
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetTopicAuthorizationRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetTopicAuthorizationRulePlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetTopicAuthorizationRulePlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicAuthorizationRulePlainArgs].
 */
@PulumiTagMarker
public class GetTopicAuthorizationRulePlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("yhevypkxakknplno")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ncagqivxicmegbgm")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cgopakfkdgeeplam")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("hsjuimbjamaofakx")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetTopicAuthorizationRulePlainArgs = GetTopicAuthorizationRulePlainArgs(
        authorizationRuleName = authorizationRuleName ?: throw
            PulumiNullFieldException("authorizationRuleName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
