@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.ListQueueKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property queueName The queue name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class ListQueueKeysPlainArgs(
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val queueName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.ListQueueKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.ListQueueKeysPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.ListQueueKeysPlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .queueName(queueName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListQueueKeysPlainArgs].
 */
@PulumiTagMarker
public class ListQueueKeysPlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var queueName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("dcgpgbnogtcefldx")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("wfytqttqshmuwufm")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The queue name.
     */
    @JvmName("kyorumcyydcbghmo")
    public suspend fun queueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.queueName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("fttjllnjkoqmwenr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListQueueKeysPlainArgs = ListQueueKeysPlainArgs(
        authorizationRuleName = authorizationRuleName ?: throw
            PulumiNullFieldException("authorizationRuleName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        queueName = queueName ?: throw PulumiNullFieldException("queueName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
