@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.NWRuleSetVirtualNetworkRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of VirtualNetworkRules - NetworkRules resource.
 * @property ignoreMissingVnetServiceEndpoint Value that indicates whether to ignore missing VNet Service Endpoint
 * @property subnet Subnet properties
 */
public data class NWRuleSetVirtualNetworkRulesArgs(
    public val ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null,
    public val subnet: Output<SubnetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.NWRuleSetVirtualNetworkRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.NWRuleSetVirtualNetworkRulesArgs =
        com.pulumi.azurenative.servicebus.inputs.NWRuleSetVirtualNetworkRulesArgs.builder()
            .ignoreMissingVnetServiceEndpoint(ignoreMissingVnetServiceEndpoint?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NWRuleSetVirtualNetworkRulesArgs].
 */
@PulumiTagMarker
public class NWRuleSetVirtualNetworkRulesArgsBuilder internal constructor() {
    private var ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null

    private var subnet: Output<SubnetArgs>? = null

    /**
     * @param value Value that indicates whether to ignore missing VNet Service Endpoint
     */
    @JvmName("vdtkyoprslvudswq")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Output<Boolean>) {
        this.ignoreMissingVnetServiceEndpoint = value
    }

    /**
     * @param value Subnet properties
     */
    @JvmName("lmgpdcketcrxpnvv")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Value that indicates whether to ignore missing VNet Service Endpoint
     */
    @JvmName("jetlrfuituvohklh")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMissingVnetServiceEndpoint = mapped
    }

    /**
     * @param value Subnet properties
     */
    @JvmName("ivdfpgrhfxbyklgn")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Subnet properties
     */
    @JvmName("garqgxbecxukjrgb")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): NWRuleSetVirtualNetworkRulesArgs = NWRuleSetVirtualNetworkRulesArgs(
        ignoreMissingVnetServiceEndpoint = ignoreMissingVnetServiceEndpoint,
        subnet = subnet,
    )
}
