@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.SBClientAffinePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties specific to client affine subscriptions.
 * @property clientId Indicates the Client ID of the application that created the client-affine subscription.
 * @property isDurable For client-affine subscriptions, this value indicates whether the subscription is durable or not.
 * @property isShared For client-affine subscriptions, this value indicates whether the subscription is shared or not.
 */
public data class SBClientAffinePropertiesArgs(
    public val clientId: Output<String>? = null,
    public val isDurable: Output<Boolean>? = null,
    public val isShared: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.SBClientAffinePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.SBClientAffinePropertiesArgs =
        com.pulumi.azurenative.servicebus.inputs.SBClientAffinePropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .isDurable(isDurable?.applyValue({ args0 -> args0 }))
            .isShared(isShared?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SBClientAffinePropertiesArgs].
 */
@PulumiTagMarker
public class SBClientAffinePropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var isDurable: Output<Boolean>? = null

    private var isShared: Output<Boolean>? = null

    /**
     * @param value Indicates the Client ID of the application that created the client-affine subscription.
     */
    @JvmName("duerenvngcqwbclp")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value For client-affine subscriptions, this value indicates whether the subscription is durable or not.
     */
    @JvmName("cnkugxagtgvqtson")
    public suspend fun isDurable(`value`: Output<Boolean>) {
        this.isDurable = value
    }

    /**
     * @param value For client-affine subscriptions, this value indicates whether the subscription is shared or not.
     */
    @JvmName("veqbsyjkyrssyilu")
    public suspend fun isShared(`value`: Output<Boolean>) {
        this.isShared = value
    }

    /**
     * @param value Indicates the Client ID of the application that created the client-affine subscription.
     */
    @JvmName("knubgboncnamdton")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value For client-affine subscriptions, this value indicates whether the subscription is durable or not.
     */
    @JvmName("ybuuabyrvrdkrujc")
    public suspend fun isDurable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDurable = mapped
    }

    /**
     * @param value For client-affine subscriptions, this value indicates whether the subscription is shared or not.
     */
    @JvmName("gveapbeccddtxnax")
    public suspend fun isShared(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isShared = mapped
    }

    internal fun build(): SBClientAffinePropertiesArgs = SBClientAffinePropertiesArgs(
        clientId = clientId,
        isDurable = isDurable,
        isShared = isShared,
    )
}
