@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Single item in List or Get Migration Config operation
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property migrationState State in which Standard to Premium Migration is, possible values : Unknown, Reverting, Completing, Initiating, Syncing, Active
 * @property name The name of the resource
 * @property pendingReplicationOperationsCount Number of entities pending to be replicated.
 * @property postMigrationName Name to access Standard Namespace after migration
 * @property provisioningState Provisioning state of Migration Configuration
 * @property systemData The system meta data relating to this resource.
 * @property targetNamespace Existing premium Namespace ARM Id name which has no entities, will be used for migration
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 */
public data class GetMigrationConfigResult(
    public val id: String,
    public val location: String,
    public val migrationState: String,
    public val name: String,
    public val pendingReplicationOperationsCount: Double,
    public val postMigrationName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val targetNamespace: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetMigrationConfigResult):
            GetMigrationConfigResult = GetMigrationConfigResult(
            id = javaType.id(),
            location = javaType.location(),
            migrationState = javaType.migrationState(),
            name = javaType.name(),
            pendingReplicationOperationsCount = javaType.pendingReplicationOperationsCount(),
            postMigrationName = javaType.postMigrationName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetNamespace = javaType.targetNamespace(),
            type = javaType.type(),
        )
    }
}
