@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Message Count Details.
 * @property activeMessageCount Number of active messages in the queue, topic, or subscription.
 * @property deadLetterMessageCount Number of messages that are dead lettered.
 * @property scheduledMessageCount Number of scheduled messages.
 * @property transferDeadLetterMessageCount Number of messages transferred into dead letters.
 * @property transferMessageCount Number of messages transferred to another queue, topic, or subscription.
 */
public data class MessageCountDetailsResponse(
    public val activeMessageCount: Double,
    public val deadLetterMessageCount: Double,
    public val scheduledMessageCount: Double,
    public val transferDeadLetterMessageCount: Double,
    public val transferMessageCount: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.MessageCountDetailsResponse):
            MessageCountDetailsResponse = MessageCountDetailsResponse(
            activeMessageCount = javaType.activeMessageCount(),
            deadLetterMessageCount = javaType.deadLetterMessageCount(),
            scheduledMessageCount = javaType.scheduledMessageCount(),
            transferDeadLetterMessageCount = javaType.transferDeadLetterMessageCount(),
            transferMessageCount = javaType.transferMessageCount(),
        )
    }
}
