@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ManagedClusterApplicationType].
 */
@PulumiTagMarker
public class ManagedClusterApplicationTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedClusterApplicationTypeArgs = ManagedClusterApplicationTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedClusterApplicationTypeArgsBuilder.() -> Unit) {
        val builder = ManagedClusterApplicationTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedClusterApplicationType {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabric.ManagedClusterApplicationType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedClusterApplicationType(builtJavaResource)
    }
}

/**
 * The application type name resource
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Put an application type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplicationType = new AzureNative.ServiceFabric.ManagedClusterApplicationType("managedClusterApplicationType", new()
 *     {
 *         ApplicationTypeName = "myAppType",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplicationType(ctx, "managedClusterApplicationType", &servicefabric.ManagedClusterApplicationTypeArgs{
 * 			ApplicationTypeName: pulumi.String("myAppType"),
 * 			ClusterName:         pulumi.String("myCluster"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationType;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplicationType = new ManagedClusterApplicationType("managedClusterApplicationType", ManagedClusterApplicationTypeArgs.builder()
 *             .applicationTypeName("myAppType")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterApplicationType myAppType /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applicationTypes/{applicationTypeName}
 * ```
 */
public class ManagedClusterApplicationType internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabric.ManagedClusterApplicationType,
) : KotlinCustomResource(javaResource, ManagedClusterApplicationTypeMapper) {
    /**
     * Resource location depends on the parent resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment or provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedClusterApplicationTypeMapper : ResourceMapper<ManagedClusterApplicationType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabric.ManagedClusterApplicationType::class == javaResource::class

    override fun map(javaResource: Resource): ManagedClusterApplicationType =
        ManagedClusterApplicationType(
            javaResource as
                com.pulumi.azurenative.servicefabric.ManagedClusterApplicationType,
        )
}

/**
 * @see [ManagedClusterApplicationType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedClusterApplicationType].
 */
public suspend fun managedClusterApplicationType(
    name: String,
    block: suspend ManagedClusterApplicationTypeResourceBuilder.() -> Unit,
):
    ManagedClusterApplicationType {
    val builder = ManagedClusterApplicationTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedClusterApplicationType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedClusterApplicationType(name: String): ManagedClusterApplicationType {
    val builder = ManagedClusterApplicationTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
