@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.kotlin.outputs.StatefulServicePropertiesResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.StatelessServicePropertiesResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ManagedClusterService].
 */
@PulumiTagMarker
public class ManagedClusterServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedClusterServiceArgs = ManagedClusterServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedClusterServiceArgsBuilder.() -> Unit) {
        val builder = ManagedClusterServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedClusterService {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabric.ManagedClusterService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedClusterService(builtJavaResource)
    }
}

/**
 * The service resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Put a service with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterService = new AzureNative.ServiceFabric.ManagedClusterService("managedClusterService", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         Properties = new AzureNative.ServiceFabric.Inputs.StatelessServicePropertiesArgs
 *         {
 *             CorrelationScheme = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ServiceCorrelationArgs
 *                 {
 *                     Scheme = "AlignedAffinity",
 *                     ServiceName = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1",
 *                 },
 *             },
 *             DefaultMoveCost = "Medium",
 *             InstanceCount = 5,
 *             MinInstanceCount = 3,
 *             MinInstancePercentage = 30,
 *             PartitionDescription = new AzureNative.ServiceFabric.Inputs.SingletonPartitionSchemeArgs
 *             {
 *                 PartitionScheme = "Singleton",
 *             },
 *             PlacementConstraints = "NodeType==frontend",
 *             ScalingPolicies = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ScalingPolicyArgs
 *                 {
 *                     ScalingMechanism = new AzureNative.ServiceFabric.Inputs.PartitionInstanceCountScaleMechanismArgs
 *                     {
 *                         Kind = "ScalePartitionInstanceCount",
 *                         MaxInstanceCount = 9,
 *                         MinInstanceCount = 3,
 *                         ScaleIncrement = 2,
 *                     },
 *                     ScalingTrigger = new AzureNative.ServiceFabric.Inputs.AveragePartitionLoadScalingTriggerArgs
 *                     {
 *                         Kind = "AveragePartitionLoadTrigger",
 *                         LowerLoadThreshold = 2,
 *                         MetricName = "metricName",
 *                         ScaleInterval = "00:01:00",
 *                         UpperLoadThreshold = 8,
 *                     },
 *                 },
 *             },
 *             ServiceDnsName = "myservicednsname.myApp",
 *             ServiceKind = "Stateless",
 *             ServiceLoadMetrics = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ServiceLoadMetricArgs
 *                 {
 *                     DefaultLoad = 3,
 *                     Name = "metric1",
 *                     Weight = "Low",
 *                 },
 *             },
 *             ServicePackageActivationMode = "SharedProcess",
 *             ServicePlacementPolicies = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ServicePlacementNonPartiallyPlaceServicePolicyArgs
 *                 {
 *                     Type = "NonPartiallyPlaceService",
 *                 },
 *             },
 *             ServiceTypeName = "myServiceType",
 *         },
 *         ResourceGroupName = "resRg",
 *         ServiceName = "myService",
 *         Tags =
 *         {
 *             { "a", "b" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterService(ctx, "managedClusterService", &servicefabric.ManagedClusterServiceArgs{
 * 			ApplicationName: pulumi.String("myApp"),
 * 			ClusterName:     pulumi.String("myCluster"),
 * 			Location:        pulumi.String("eastus"),
 * 			Properties: servicefabric.StatelessServiceProperties{
 * 				CorrelationScheme: []servicefabric.ServiceCorrelation{
 * 					{
 * 						Scheme:      "AlignedAffinity",
 * 						ServiceName: "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1",
 * 					},
 * 				},
 * 				DefaultMoveCost:       "Medium",
 * 				InstanceCount:         5,
 * 				MinInstanceCount:      3,
 * 				MinInstancePercentage: 30,
 * 				PartitionDescription: servicefabric.SingletonPartitionScheme{
 * 					PartitionScheme: "Singleton",
 * 				},
 * 				PlacementConstraints: "NodeType==frontend",
 * 				ScalingPolicies: []servicefabric.ScalingPolicy{
 * 					{
 * 						ScalingMechanism: {
 * 							Kind:             "ScalePartitionInstanceCount",
 * 							MaxInstanceCount: 9,
 * 							MinInstanceCount: 3,
 * 							ScaleIncrement:   2,
 * 						},
 * 						ScalingTrigger: {
 * 							Kind:               "AveragePartitionLoadTrigger",
 * 							LowerLoadThreshold: 2,
 * 							MetricName:         "metricName",
 * 							ScaleInterval:      "00:01:00",
 * 							UpperLoadThreshold: 8,
 * 						},
 * 					},
 * 				},
 * 				ServiceDnsName: "myservicednsname.myApp",
 * 				ServiceKind:    "Stateless",
 * 				ServiceLoadMetrics: []servicefabric.ServiceLoadMetric{
 * 					{
 * 						DefaultLoad: 3,
 * 						Name:        "metric1",
 * 						Weight:      "Low",
 * 					},
 * 				},
 * 				ServicePackageActivationMode: "SharedProcess",
 * 				ServicePlacementPolicies: []interface{}{
 * 					servicefabric.ServicePlacementNonPartiallyPlaceServicePolicy{
 * 						Type: "NonPartiallyPlaceService",
 * 					},
 * 				},
 * 				ServiceTypeName: "myServiceType",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ServiceName:       pulumi.String("myService"),
 * 			Tags: pulumi.StringMap{
 * 				"a": pulumi.String("b"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterService;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterService = new ManagedClusterService("managedClusterService", ManagedClusterServiceArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("correlationScheme", Map.ofEntries(
 *                     Map.entry("scheme", "AlignedAffinity"),
 *                     Map.entry("serviceName", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1")
 *                 )),
 *                 Map.entry("defaultMoveCost", "Medium"),
 *                 Map.entry("instanceCount", 5),
 *                 Map.entry("minInstanceCount", 3),
 *                 Map.entry("minInstancePercentage", 30),
 *                 Map.entry("partitionDescription", Map.of("partitionScheme", "Singleton")),
 *                 Map.entry("placementConstraints", "NodeType==frontend"),
 *                 Map.entry("scalingPolicies", Map.ofEntries(
 *                     Map.entry("scalingMechanism", Map.ofEntries(
 *                         Map.entry("kind", "ScalePartitionInstanceCount"),
 *                         Map.entry("maxInstanceCount", 9),
 *                         Map.entry("minInstanceCount", 3),
 *                         Map.entry("scaleIncrement", 2)
 *                     )),
 *                     Map.entry("scalingTrigger", Map.ofEntries(
 *                         Map.entry("kind", "AveragePartitionLoadTrigger"),
 *                         Map.entry("lowerLoadThreshold", 2),
 *                         Map.entry("metricName", "metricName"),
 *                         Map.entry("scaleInterval", "00:01:00"),
 *                         Map.entry("upperLoadThreshold", 8)
 *                     ))
 *                 )),
 *                 Map.entry("serviceDnsName", "myservicednsname.myApp"),
 *                 Map.entry("serviceKind", "Stateless"),
 *                 Map.entry("serviceLoadMetrics", Map.ofEntries(
 *                     Map.entry("defaultLoad", 3),
 *                     Map.entry("name", "metric1"),
 *                     Map.entry("weight", "Low")
 *                 )),
 *                 Map.entry("servicePackageActivationMode", "SharedProcess"),
 *                 Map.entry("servicePlacementPolicies", Map.of("type", "NonPartiallyPlaceService")),
 *                 Map.entry("serviceTypeName", "myServiceType")
 *             ))
 *             .resourceGroupName("resRg")
 *             .serviceName("myService")
 *             .tags(Map.of("a", "b"))
 *             .build());
 *     }
 * }
 * ```
 * ### Put a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterService = new AzureNative.ServiceFabric.ManagedClusterService("managedClusterService", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         Properties = new AzureNative.ServiceFabric.Inputs.StatelessServicePropertiesArgs
 *         {
 *             InstanceCount = 1,
 *             PartitionDescription = new AzureNative.ServiceFabric.Inputs.SingletonPartitionSchemeArgs
 *             {
 *                 PartitionScheme = "Singleton",
 *             },
 *             ServiceKind = "Stateless",
 *             ServiceTypeName = "myServiceType",
 *         },
 *         ResourceGroupName = "resRg",
 *         ServiceName = "myService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterService(ctx, "managedClusterService", &servicefabric.ManagedClusterServiceArgs{
 * 			ApplicationName: pulumi.String("myApp"),
 * 			ClusterName:     pulumi.String("myCluster"),
 * 			Location:        pulumi.String("eastus"),
 * 			Properties: servicefabric.StatelessServiceProperties{
 * 				InstanceCount: 1,
 * 				PartitionDescription: servicefabric.SingletonPartitionScheme{
 * 					PartitionScheme: "Singleton",
 * 				},
 * 				ServiceKind:     "Stateless",
 * 				ServiceTypeName: "myServiceType",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ServiceName:       pulumi.String("myService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterService;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterService = new ManagedClusterService("managedClusterService", ManagedClusterServiceArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("instanceCount", 1),
 *                 Map.entry("partitionDescription", Map.of("partitionScheme", "Singleton")),
 *                 Map.entry("serviceKind", "Stateless"),
 *                 Map.entry("serviceTypeName", "myServiceType")
 *             ))
 *             .resourceGroupName("resRg")
 *             .serviceName("myService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterService myService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applications/{applicationName}/services/{serviceName}
 * ```
 */
public class ManagedClusterService internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabric.ManagedClusterService,
) : KotlinCustomResource(javaResource, ManagedClusterServiceMapper) {
    /**
     * Resource location depends on the parent resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service resource properties.
     */
    public val properties:
        Output<Either<StatefulServicePropertiesResponse, StatelessServicePropertiesResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.StatefulServicePropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.StatelessServicePropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedClusterServiceMapper : ResourceMapper<ManagedClusterService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabric.ManagedClusterService::class == javaResource::class

    override fun map(javaResource: Resource): ManagedClusterService =
        ManagedClusterService(
            javaResource as
                com.pulumi.azurenative.servicefabric.ManagedClusterService,
        )
}

/**
 * @see [ManagedClusterService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedClusterService].
 */
public suspend fun managedClusterService(
    name: String,
    block: suspend ManagedClusterServiceResourceBuilder.() -> Unit,
): ManagedClusterService {
    val builder = ManagedClusterServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedClusterService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedClusterService(name: String): ManagedClusterService {
    val builder = ManagedClusterServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
