@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The upgrade mode of the cluster when new Service Fabric runtime version is available.
 */
public enum class ClusterUpgradeMode(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeMode,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeMode> {
    /**
     * The cluster will be automatically upgraded to the latest Service Fabric runtime version, **clusterUpgradeCadence** will determine when the upgrade starts after the new version becomes available.
     */
    Automatic(com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeMode.Automatic),

    /**
     * The cluster will not be automatically upgraded to the latest Service Fabric runtime version. The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster resource.
     */
    Manual(com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeMode.Manual),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeMode):
            ClusterUpgradeMode = ClusterUpgradeMode.values().first { it.javaValue == javaType }
    }
}
