@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
 */
public enum class EvictionPolicyType(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.EvictionPolicyType,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.EvictionPolicyType> {
    /**
     * Eviction policy will be Delete for SPOT vms.
     */
    Delete(com.pulumi.azurenative.servicefabric.enums.EvictionPolicyType.Delete),

    /**
     * Eviction policy will be Deallocate for SPOT vms.
     */
    Deallocate(com.pulumi.azurenative.servicefabric.enums.EvictionPolicyType.Deallocate),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.EvictionPolicyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.EvictionPolicyType):
            EvictionPolicyType = EvictionPolicyType.values().first { it.javaValue == javaType }
    }
}
