@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IP address type of this frontend configuration. If omitted the default value is IPv4.
 */
public enum class IPAddressType(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.IPAddressType,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.IPAddressType> {
    /**
     * IPv4 address type.
     */
    IPv4(com.pulumi.azurenative.servicefabric.enums.IPAddressType.IPv4),

    /**
     * IPv6 address type.
     */
    IPv6(com.pulumi.azurenative.servicefabric.enums.IPAddressType.IPv6),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.IPAddressType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.IPAddressType):
            IPAddressType = IPAddressType.values().first { it.javaValue == javaType }
    }
}
