@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
 */
public enum class SecurityType(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.SecurityType,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.SecurityType> {
    /**
     * Trusted Launch is a security type that secures generation 2 virtual machines.
     */
    TrustedLaunch(com.pulumi.azurenative.servicefabric.enums.SecurityType.TrustedLaunch),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.SecurityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.SecurityType):
            SecurityType = SecurityType.values().first { it.javaValue == javaType }
    }
}
