@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the update mode for Cross Az clusters.
 */
public enum class ZonalUpdateMode(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ZonalUpdateMode,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ZonalUpdateMode> {
    /**
     * The cluster will use 5 upgrade domains for Cross Az Node types.
     */
    Standard(com.pulumi.azurenative.servicefabric.enums.ZonalUpdateMode.Standard),

    /**
     * The cluster will use a maximum of 3 upgrade domains per zone instead of 5 for Cross Az Node types for faster deployments.
     */
    Fast(com.pulumi.azurenative.servicefabric.enums.ZonalUpdateMode.Fast),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ZonalUpdateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ZonalUpdateMode):
            ZonalUpdateMode = ZonalUpdateMode.values().first { it.javaValue == javaType }
    }
}
