@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ApplicationHealthPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines a health policy used to evaluate the health of an application or one of its children entities.
 * @property considerWarningAsError Indicates whether warnings are treated with the same severity as errors.
 * @property defaultServiceTypeHealthPolicy The health policy used by default to evaluate the health of a service type.
 * @property maxPercentUnhealthyDeployedApplications The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
 * The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
 * This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
 * The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
 * @property serviceTypeHealthPolicyMap The map with service type health policy per service type name. The map is empty by default.
 */
public data class ApplicationHealthPolicyArgs(
    public val considerWarningAsError: Output<Boolean>,
    public val defaultServiceTypeHealthPolicy: Output<ServiceTypeHealthPolicyArgs>? = null,
    public val maxPercentUnhealthyDeployedApplications: Output<Int>,
    public val serviceTypeHealthPolicyMap: Output<Map<String, ServiceTypeHealthPolicyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ApplicationHealthPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ApplicationHealthPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ApplicationHealthPolicyArgs.builder()
            .considerWarningAsError(considerWarningAsError.applyValue({ args0 -> args0 }))
            .defaultServiceTypeHealthPolicy(
                defaultServiceTypeHealthPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .maxPercentUnhealthyDeployedApplications(
                maxPercentUnhealthyDeployedApplications.applyValue({ args0 ->
                    args0
                }),
            )
            .serviceTypeHealthPolicyMap(
                serviceTypeHealthPolicyMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationHealthPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationHealthPolicyArgsBuilder internal constructor() {
    private var considerWarningAsError: Output<Boolean>? = null

    private var defaultServiceTypeHealthPolicy: Output<ServiceTypeHealthPolicyArgs>? = null

    private var maxPercentUnhealthyDeployedApplications: Output<Int>? = null

    private var serviceTypeHealthPolicyMap: Output<Map<String, ServiceTypeHealthPolicyArgs>>? = null

    /**
     * @param value Indicates whether warnings are treated with the same severity as errors.
     */
    @JvmName("ewwhwhwultsnfwdv")
    public suspend fun considerWarningAsError(`value`: Output<Boolean>) {
        this.considerWarningAsError = value
    }

    /**
     * @param value The health policy used by default to evaluate the health of a service type.
     */
    @JvmName("vypnpqjmliqeotjm")
    public suspend fun defaultServiceTypeHealthPolicy(`value`: Output<ServiceTypeHealthPolicyArgs>) {
        this.defaultServiceTypeHealthPolicy = value
    }

    /**
     * @param value The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
     * The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
     * This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
     * The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
     */
    @JvmName("kgwgnhcqjoixkffb")
    public suspend fun maxPercentUnhealthyDeployedApplications(`value`: Output<Int>) {
        this.maxPercentUnhealthyDeployedApplications = value
    }

    /**
     * @param value The map with service type health policy per service type name. The map is empty by default.
     */
    @JvmName("xdylkhawdgoodtna")
    public suspend
    fun serviceTypeHealthPolicyMap(`value`: Output<Map<String, ServiceTypeHealthPolicyArgs>>) {
        this.serviceTypeHealthPolicyMap = value
    }

    /**
     * @param value Indicates whether warnings are treated with the same severity as errors.
     */
    @JvmName("yordqhefesuukood")
    public suspend fun considerWarningAsError(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.considerWarningAsError = mapped
    }

    /**
     * @param value The health policy used by default to evaluate the health of a service type.
     */
    @JvmName("hdlpmmkaakeedhip")
    public suspend fun defaultServiceTypeHealthPolicy(`value`: ServiceTypeHealthPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultServiceTypeHealthPolicy = mapped
    }

    /**
     * @param argument The health policy used by default to evaluate the health of a service type.
     */
    @JvmName("wntkcimhdvwmhxxg")
    public suspend
    fun defaultServiceTypeHealthPolicy(argument: suspend ServiceTypeHealthPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceTypeHealthPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultServiceTypeHealthPolicy = mapped
    }

    /**
     * @param value The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
     * The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
     * This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
     * The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
     */
    @JvmName("flrsgndutpphjddi")
    public suspend fun maxPercentUnhealthyDeployedApplications(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPercentUnhealthyDeployedApplications = mapped
    }

    /**
     * @param value The map with service type health policy per service type name. The map is empty by default.
     */
    @JvmName("fwwvbjladylvxunn")
    public suspend
    fun serviceTypeHealthPolicyMap(`value`: Map<String, ServiceTypeHealthPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTypeHealthPolicyMap = mapped
    }

    /**
     * @param argument The map with service type health policy per service type name. The map is empty by default.
     */
    @JvmName("nivwrvgwpdieqwmy")
    public suspend fun serviceTypeHealthPolicyMap(
        vararg
        argument: Pair<String, suspend ServiceTypeHealthPolicyArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ServiceTypeHealthPolicyArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.serviceTypeHealthPolicyMap = mapped
    }

    /**
     * @param values The map with service type health policy per service type name. The map is empty by default.
     */
    @JvmName("lfajwjmiayygkggy")
    public fun serviceTypeHealthPolicyMap(vararg values: Pair<String, ServiceTypeHealthPolicyArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceTypeHealthPolicyMap = mapped
    }

    internal fun build(): ApplicationHealthPolicyArgs = ApplicationHealthPolicyArgs(
        considerWarningAsError = considerWarningAsError ?: throw
            PulumiNullFieldException("considerWarningAsError"),
        defaultServiceTypeHealthPolicy = defaultServiceTypeHealthPolicy,
        maxPercentUnhealthyDeployedApplications = maxPercentUnhealthyDeployedApplications ?: throw
            PulumiNullFieldException("maxPercentUnhealthyDeployedApplications"),
        serviceTypeHealthPolicyMap = serviceTypeHealthPolicyMap,
    )
}
