@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ApplicationTypeVersionsCleanupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The policy used to clean up unused versions. When the policy is not specified explicitly, the default unused application versions to keep will be 3.
 * @property maxUnusedVersionsToKeep Number of unused versions per application type to keep.
 */
public data class ApplicationTypeVersionsCleanupPolicyArgs(
    public val maxUnusedVersionsToKeep: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ApplicationTypeVersionsCleanupPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.ApplicationTypeVersionsCleanupPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ApplicationTypeVersionsCleanupPolicyArgs.builder()
            .maxUnusedVersionsToKeep(maxUnusedVersionsToKeep.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationTypeVersionsCleanupPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationTypeVersionsCleanupPolicyArgsBuilder internal constructor() {
    private var maxUnusedVersionsToKeep: Output<Int>? = null

    /**
     * @param value Number of unused versions per application type to keep.
     */
    @JvmName("yhuyvdcfkdvlvksw")
    public suspend fun maxUnusedVersionsToKeep(`value`: Output<Int>) {
        this.maxUnusedVersionsToKeep = value
    }

    /**
     * @param value Number of unused versions per application type to keep.
     */
    @JvmName("xaxmvlejaqbwylkr")
    public suspend fun maxUnusedVersionsToKeep(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxUnusedVersionsToKeep = mapped
    }

    internal fun build(): ApplicationTypeVersionsCleanupPolicyArgs =
        ApplicationTypeVersionsCleanupPolicyArgs(
            maxUnusedVersionsToKeep = maxUnusedVersionsToKeep ?: throw
                PulumiNullFieldException("maxUnusedVersionsToKeep"),
        )
}
