@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ApplicationUpgradePolicyArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.RollingUpgradeMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the policy for a monitored application upgrade.
 * @property applicationHealthPolicy Defines a health policy used to evaluate the health of an application or one of its children entities.
 * @property forceRestart If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
 * @property instanceCloseDelayDuration Duration in seconds, to wait before a stateless instance is closed, to allow the active requests to drain gracefully. This would be effective when the instance is closing during the application/cluster upgrade, only for those instances which have a non-zero delay duration configured in the service description.
 * @property recreateApplication Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed.
 * @property rollingUpgradeMonitoringPolicy The policy used for monitoring the application upgrade
 * @property upgradeMode The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
 * @property upgradeReplicaSetCheckTimeout The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
 */
public data class ApplicationUpgradePolicyArgs(
    public val applicationHealthPolicy: Output<ApplicationHealthPolicyArgs>? = null,
    public val forceRestart: Output<Boolean>? = null,
    public val instanceCloseDelayDuration: Output<Double>? = null,
    public val recreateApplication: Output<Boolean>? = null,
    public val rollingUpgradeMonitoringPolicy: Output<RollingUpgradeMonitoringPolicyArgs>? = null,
    public val upgradeMode: Output<Either<String, RollingUpgradeMode>>? = null,
    public val upgradeReplicaSetCheckTimeout: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ApplicationUpgradePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ApplicationUpgradePolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ApplicationUpgradePolicyArgs.builder()
            .applicationHealthPolicy(
                applicationHealthPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .forceRestart(forceRestart?.applyValue({ args0 -> args0 }))
            .instanceCloseDelayDuration(instanceCloseDelayDuration?.applyValue({ args0 -> args0 }))
            .recreateApplication(recreateApplication?.applyValue({ args0 -> args0 }))
            .rollingUpgradeMonitoringPolicy(
                rollingUpgradeMonitoringPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .upgradeMode(
                upgradeMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .upgradeReplicaSetCheckTimeout(
                upgradeReplicaSetCheckTimeout?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ApplicationUpgradePolicyArgs].
 */
@PulumiTagMarker
public class ApplicationUpgradePolicyArgsBuilder internal constructor() {
    private var applicationHealthPolicy: Output<ApplicationHealthPolicyArgs>? = null

    private var forceRestart: Output<Boolean>? = null

    private var instanceCloseDelayDuration: Output<Double>? = null

    private var recreateApplication: Output<Boolean>? = null

    private var rollingUpgradeMonitoringPolicy: Output<RollingUpgradeMonitoringPolicyArgs>? = null

    private var upgradeMode: Output<Either<String, RollingUpgradeMode>>? = null

    private var upgradeReplicaSetCheckTimeout: Output<Double>? = null

    /**
     * @param value Defines a health policy used to evaluate the health of an application or one of its children entities.
     */
    @JvmName("tvdswgiicjxlhwtd")
    public suspend fun applicationHealthPolicy(`value`: Output<ApplicationHealthPolicyArgs>) {
        this.applicationHealthPolicy = value
    }

    /**
     * @param value If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
     */
    @JvmName("yprmenfuwwpyvoeq")
    public suspend fun forceRestart(`value`: Output<Boolean>) {
        this.forceRestart = value
    }

    /**
     * @param value Duration in seconds, to wait before a stateless instance is closed, to allow the active requests to drain gracefully. This would be effective when the instance is closing during the application/cluster upgrade, only for those instances which have a non-zero delay duration configured in the service description.
     */
    @JvmName("ufdkfygygfnjdffg")
    public suspend fun instanceCloseDelayDuration(`value`: Output<Double>) {
        this.instanceCloseDelayDuration = value
    }

    /**
     * @param value Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed.
     */
    @JvmName("dpkbocyftjsxebek")
    public suspend fun recreateApplication(`value`: Output<Boolean>) {
        this.recreateApplication = value
    }

    /**
     * @param value The policy used for monitoring the application upgrade
     */
    @JvmName("jtnkvbgutmohihjy")
    public suspend
    fun rollingUpgradeMonitoringPolicy(`value`: Output<RollingUpgradeMonitoringPolicyArgs>) {
        this.rollingUpgradeMonitoringPolicy = value
    }

    /**
     * @param value The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
     */
    @JvmName("nksxthudjvnphcwg")
    public suspend fun upgradeMode(`value`: Output<Either<String, RollingUpgradeMode>>) {
        this.upgradeMode = value
    }

    /**
     * @param value The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
     */
    @JvmName("anrbluyyxnwabxxh")
    public suspend fun upgradeReplicaSetCheckTimeout(`value`: Output<Double>) {
        this.upgradeReplicaSetCheckTimeout = value
    }

    /**
     * @param value Defines a health policy used to evaluate the health of an application or one of its children entities.
     */
    @JvmName("oqehoecciqlalxhm")
    public suspend fun applicationHealthPolicy(`value`: ApplicationHealthPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationHealthPolicy = mapped
    }

    /**
     * @param argument Defines a health policy used to evaluate the health of an application or one of its children entities.
     */
    @JvmName("pmkhbwifkdrohcqo")
    public suspend
    fun applicationHealthPolicy(argument: suspend ApplicationHealthPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationHealthPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationHealthPolicy = mapped
    }

    /**
     * @param value If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
     */
    @JvmName("pobbhbvdracpvifd")
    public suspend fun forceRestart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceRestart = mapped
    }

    /**
     * @param value Duration in seconds, to wait before a stateless instance is closed, to allow the active requests to drain gracefully. This would be effective when the instance is closing during the application/cluster upgrade, only for those instances which have a non-zero delay duration configured in the service description.
     */
    @JvmName("ympntaibiukbcuww")
    public suspend fun instanceCloseDelayDuration(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCloseDelayDuration = mapped
    }

    /**
     * @param value Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed.
     */
    @JvmName("domgfcwpmesugwel")
    public suspend fun recreateApplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recreateApplication = mapped
    }

    /**
     * @param value The policy used for monitoring the application upgrade
     */
    @JvmName("didamrenfvfnbhpu")
    public suspend fun rollingUpgradeMonitoringPolicy(`value`: RollingUpgradeMonitoringPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollingUpgradeMonitoringPolicy = mapped
    }

    /**
     * @param argument The policy used for monitoring the application upgrade
     */
    @JvmName("nmfmvjfsdfenjenn")
    public suspend
    fun rollingUpgradeMonitoringPolicy(argument: suspend RollingUpgradeMonitoringPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RollingUpgradeMonitoringPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rollingUpgradeMonitoringPolicy = mapped
    }

    /**
     * @param value The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
     */
    @JvmName("wabiucwkgrbjoyws")
    public suspend fun upgradeMode(`value`: Either<String, RollingUpgradeMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeMode = mapped
    }

    /**
     * @param value The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
     */
    @JvmName("xkvuyburhsidammr")
    public fun upgradeMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RollingUpgradeMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeMode = mapped
    }

    /**
     * @param value The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
     */
    @JvmName("vjoalgnixietbgsf")
    public fun upgradeMode(`value`: RollingUpgradeMode) {
        val toBeMapped = Either.ofRight<String, RollingUpgradeMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeMode = mapped
    }

    /**
     * @param value The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
     */
    @JvmName("ggimawnibqyicjat")
    public suspend fun upgradeReplicaSetCheckTimeout(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeReplicaSetCheckTimeout = mapped
    }

    internal fun build(): ApplicationUpgradePolicyArgs = ApplicationUpgradePolicyArgs(
        applicationHealthPolicy = applicationHealthPolicy,
        forceRestart = forceRestart,
        instanceCloseDelayDuration = instanceCloseDelayDuration,
        recreateApplication = recreateApplication,
        rollingUpgradeMonitoringPolicy = rollingUpgradeMonitoringPolicy,
        upgradeMode = upgradeMode,
        upgradeReplicaSetCheckTimeout = upgradeReplicaSetCheckTimeout,
    )
}
