@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the application resource.
 * @property clusterName The name of the cluster resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetManagedClusterApplicationPlainArgs(
    public val applicationName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationPlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedClusterApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetManagedClusterApplicationPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application resource.
     */
    @JvmName("wybtytgluicnawcl")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("evabgxqdadftifbs")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lxykmqvmhmertwbc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedClusterApplicationPlainArgs =
        GetManagedClusterApplicationPlainArgs(
            applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
