@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.PartitionInstanceCountScaleMechanismArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a scaling mechanism for adding or removing instances of stateless service partition.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'ScalePartitionInstanceCount'.
 * @property maxInstanceCount Maximum number of instances of the partition.
 * @property minInstanceCount Minimum number of instances of the partition.
 * @property scaleIncrement The number of instances to add or remove during a scaling operation.
 */
public data class PartitionInstanceCountScaleMechanismArgs(
    public val kind: Output<String>,
    public val maxInstanceCount: Output<Int>,
    public val minInstanceCount: Output<Int>,
    public val scaleIncrement: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.PartitionInstanceCountScaleMechanismArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.PartitionInstanceCountScaleMechanismArgs =
        com.pulumi.azurenative.servicefabric.inputs.PartitionInstanceCountScaleMechanismArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .maxInstanceCount(maxInstanceCount.applyValue({ args0 -> args0 }))
            .minInstanceCount(minInstanceCount.applyValue({ args0 -> args0 }))
            .scaleIncrement(scaleIncrement.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionInstanceCountScaleMechanismArgs].
 */
@PulumiTagMarker
public class PartitionInstanceCountScaleMechanismArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var maxInstanceCount: Output<Int>? = null

    private var minInstanceCount: Output<Int>? = null

    private var scaleIncrement: Output<Int>? = null

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'ScalePartitionInstanceCount'.
     */
    @JvmName("udwuqtytyvhsubdh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Maximum number of instances of the partition.
     */
    @JvmName("fbqvehgboyjhrvka")
    public suspend fun maxInstanceCount(`value`: Output<Int>) {
        this.maxInstanceCount = value
    }

    /**
     * @param value Minimum number of instances of the partition.
     */
    @JvmName("dmiaqubjhjmiefqr")
    public suspend fun minInstanceCount(`value`: Output<Int>) {
        this.minInstanceCount = value
    }

    /**
     * @param value The number of instances to add or remove during a scaling operation.
     */
    @JvmName("kdrhipeyxwmbfjxf")
    public suspend fun scaleIncrement(`value`: Output<Int>) {
        this.scaleIncrement = value
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'ScalePartitionInstanceCount'.
     */
    @JvmName("bnggxucqocegbbfj")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Maximum number of instances of the partition.
     */
    @JvmName("ermnswtyjsiamhsr")
    public suspend fun maxInstanceCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxInstanceCount = mapped
    }

    /**
     * @param value Minimum number of instances of the partition.
     */
    @JvmName("dccwgtocmhfslqub")
    public suspend fun minInstanceCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minInstanceCount = mapped
    }

    /**
     * @param value The number of instances to add or remove during a scaling operation.
     */
    @JvmName("aesxnqflfwwonxhg")
    public suspend fun scaleIncrement(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleIncrement = mapped
    }

    internal fun build(): PartitionInstanceCountScaleMechanismArgs =
        PartitionInstanceCountScaleMechanismArgs(
            kind = kind ?: throw PulumiNullFieldException("kind"),
            maxInstanceCount = maxInstanceCount ?: throw PulumiNullFieldException("maxInstanceCount"),
            minInstanceCount = minInstanceCount ?: throw PulumiNullFieldException("minInstanceCount"),
            scaleIncrement = scaleIncrement ?: throw PulumiNullFieldException("scaleIncrement"),
        )
}
