@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ScalingPolicyArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies a metric to load balance a service during runtime.
 * @property scalingMechanism Specifies the mechanism associated with this scaling policy
 * @property scalingTrigger Specifies the trigger associated with this scaling policy.
 */
public data class ScalingPolicyArgs(
    public val scalingMechanism:
    Output<Either<AddRemoveIncrementalNamedPartitionScalingMechanismArgs, PartitionInstanceCountScaleMechanismArgs>>,
    public val scalingTrigger:
    Output<Either<AveragePartitionLoadScalingTriggerArgs, AverageServiceLoadScalingTriggerArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ScalingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ScalingPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ScalingPolicyArgs.builder()
            .scalingMechanism(
                scalingMechanism.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .scalingTrigger(
                scalingTrigger.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ScalingPolicyArgs].
 */
@PulumiTagMarker
public class ScalingPolicyArgsBuilder internal constructor() {
    private var scalingMechanism:
        Output<Either<AddRemoveIncrementalNamedPartitionScalingMechanismArgs, PartitionInstanceCountScaleMechanismArgs>>? =
        null

    private var scalingTrigger:
        Output<Either<AveragePartitionLoadScalingTriggerArgs, AverageServiceLoadScalingTriggerArgs>>? =
        null

    /**
     * @param value Specifies the mechanism associated with this scaling policy
     */
    @JvmName("rjkatcnbaeeirfev")
    public suspend
    fun scalingMechanism(`value`: Output<Either<AddRemoveIncrementalNamedPartitionScalingMechanismArgs, PartitionInstanceCountScaleMechanismArgs>>) {
        this.scalingMechanism = value
    }

    /**
     * @param value Specifies the trigger associated with this scaling policy.
     */
    @JvmName("elfeprxwlyatcqab")
    public suspend
    fun scalingTrigger(`value`: Output<Either<AveragePartitionLoadScalingTriggerArgs, AverageServiceLoadScalingTriggerArgs>>) {
        this.scalingTrigger = value
    }

    /**
     * @param value Specifies the mechanism associated with this scaling policy
     */
    @JvmName("uneokgeeiydutxbg")
    public suspend
    fun scalingMechanism(`value`: Either<AddRemoveIncrementalNamedPartitionScalingMechanismArgs, PartitionInstanceCountScaleMechanismArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingMechanism = mapped
    }

    /**
     * @param value Specifies the mechanism associated with this scaling policy
     */
    @JvmName("maaawljjamdjofay")
    public fun scalingMechanism(`value`: AddRemoveIncrementalNamedPartitionScalingMechanismArgs) {
        val toBeMapped = Either.ofLeft<AddRemoveIncrementalNamedPartitionScalingMechanismArgs,
            PartitionInstanceCountScaleMechanismArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingMechanism = mapped
    }

    /**
     * @param value Specifies the mechanism associated with this scaling policy
     */
    @JvmName("hoqtjqmfiapmqsit")
    public fun scalingMechanism(`value`: PartitionInstanceCountScaleMechanismArgs) {
        val toBeMapped = Either.ofRight<AddRemoveIncrementalNamedPartitionScalingMechanismArgs,
            PartitionInstanceCountScaleMechanismArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingMechanism = mapped
    }

    /**
     * @param value Specifies the trigger associated with this scaling policy.
     */
    @JvmName("unorhwnffxkhglsa")
    public suspend
    fun scalingTrigger(`value`: Either<AveragePartitionLoadScalingTriggerArgs, AverageServiceLoadScalingTriggerArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingTrigger = mapped
    }

    /**
     * @param value Specifies the trigger associated with this scaling policy.
     */
    @JvmName("chljdpqyybefxvds")
    public fun scalingTrigger(`value`: AveragePartitionLoadScalingTriggerArgs) {
        val toBeMapped = Either.ofLeft<AveragePartitionLoadScalingTriggerArgs,
            AverageServiceLoadScalingTriggerArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingTrigger = mapped
    }

    /**
     * @param value Specifies the trigger associated with this scaling policy.
     */
    @JvmName("komvdbsvpywbwajo")
    public fun scalingTrigger(`value`: AverageServiceLoadScalingTriggerArgs) {
        val toBeMapped = Either.ofRight<AveragePartitionLoadScalingTriggerArgs,
            AverageServiceLoadScalingTriggerArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingTrigger = mapped
    }

    internal fun build(): ScalingPolicyArgs = ScalingPolicyArgs(
        scalingMechanism = scalingMechanism ?: throw PulumiNullFieldException("scalingMechanism"),
        scalingTrigger = scalingTrigger ?: throw PulumiNullFieldException("scalingTrigger"),
    )
}
