@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServiceLoadMetricArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.ServiceLoadMetricWeight
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies a metric to load balance a service during runtime.
 * @property defaultLoad Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
 * @property name The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
 * @property primaryDefaultLoad Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
 * @property secondaryDefaultLoad Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
 * @property weight The service load metric relative weight, compared to other metrics configured for this service, as a number.
 */
public data class ServiceLoadMetricArgs(
    public val defaultLoad: Output<Int>? = null,
    public val name: Output<String>,
    public val primaryDefaultLoad: Output<Int>? = null,
    public val secondaryDefaultLoad: Output<Int>? = null,
    public val weight: Output<Either<String, ServiceLoadMetricWeight>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServiceLoadMetricArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ServiceLoadMetricArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServiceLoadMetricArgs.builder()
            .defaultLoad(defaultLoad?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .primaryDefaultLoad(primaryDefaultLoad?.applyValue({ args0 -> args0 }))
            .secondaryDefaultLoad(secondaryDefaultLoad?.applyValue({ args0 -> args0 }))
            .weight(
                weight?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceLoadMetricArgs].
 */
@PulumiTagMarker
public class ServiceLoadMetricArgsBuilder internal constructor() {
    private var defaultLoad: Output<Int>? = null

    private var name: Output<String>? = null

    private var primaryDefaultLoad: Output<Int>? = null

    private var secondaryDefaultLoad: Output<Int>? = null

    private var weight: Output<Either<String, ServiceLoadMetricWeight>>? = null

    /**
     * @param value Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
     */
    @JvmName("dnkyvatueffuvxkn")
    public suspend fun defaultLoad(`value`: Output<Int>) {
        this.defaultLoad = value
    }

    /**
     * @param value The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
     */
    @JvmName("tboykkoqjaxbidpf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
     */
    @JvmName("pooybarhysftfwut")
    public suspend fun primaryDefaultLoad(`value`: Output<Int>) {
        this.primaryDefaultLoad = value
    }

    /**
     * @param value Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
     */
    @JvmName("iivroxjpmpgcfwcg")
    public suspend fun secondaryDefaultLoad(`value`: Output<Int>) {
        this.secondaryDefaultLoad = value
    }

    /**
     * @param value The service load metric relative weight, compared to other metrics configured for this service, as a number.
     */
    @JvmName("sdryntdtmvsuvuxg")
    public suspend fun weight(`value`: Output<Either<String, ServiceLoadMetricWeight>>) {
        this.weight = value
    }

    /**
     * @param value Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
     */
    @JvmName("jvblgtdbmxemxhvp")
    public suspend fun defaultLoad(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLoad = mapped
    }

    /**
     * @param value The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
     */
    @JvmName("bmflapmfaxyyfkui")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
     */
    @JvmName("iyfxctxwjoeyuktr")
    public suspend fun primaryDefaultLoad(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryDefaultLoad = mapped
    }

    /**
     * @param value Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
     */
    @JvmName("wcrfwoflfbsrfpic")
    public suspend fun secondaryDefaultLoad(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryDefaultLoad = mapped
    }

    /**
     * @param value The service load metric relative weight, compared to other metrics configured for this service, as a number.
     */
    @JvmName("cahhaoudhcrynmlo")
    public suspend fun weight(`value`: Either<String, ServiceLoadMetricWeight>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    /**
     * @param value The service load metric relative weight, compared to other metrics configured for this service, as a number.
     */
    @JvmName("yianlgivdxtkmlll")
    public fun weight(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceLoadMetricWeight>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    /**
     * @param value The service load metric relative weight, compared to other metrics configured for this service, as a number.
     */
    @JvmName("wcqaurwcdhiedmit")
    public fun weight(`value`: ServiceLoadMetricWeight) {
        val toBeMapped = Either.ofRight<String, ServiceLoadMetricWeight>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ServiceLoadMetricArgs = ServiceLoadMetricArgs(
        defaultLoad = defaultLoad,
        name = name ?: throw PulumiNullFieldException("name"),
        primaryDefaultLoad = primaryDefaultLoad,
        secondaryDefaultLoad = secondaryDefaultLoad,
        weight = weight,
    )
}
