@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequiredDomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the policy to be used for placement of a Service Fabric service where the instances or replicas of that service must be placed in a particular domain.
 * @property domainName The name of the domain that should used for placement as per this policy.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'RequiredDomain'.
 */
public data class ServicePlacementRequiredDomainPolicyArgs(
    public val domainName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequiredDomainPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequiredDomainPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequiredDomainPolicyArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePlacementRequiredDomainPolicyArgs].
 */
@PulumiTagMarker
public class ServicePlacementRequiredDomainPolicyArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the domain that should used for placement as per this policy.
     */
    @JvmName("cgndhavagtmulavb")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'RequiredDomain'.
     */
    @JvmName("unonllxkrkoqhdhi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the domain that should used for placement as per this policy.
     */
    @JvmName("otgjunyhaenhqelc")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'RequiredDomain'.
     */
    @JvmName("wfrdqhgnagyybmvp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePlacementRequiredDomainPolicyArgs =
        ServicePlacementRequiredDomainPolicyArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
