@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.SettingsParameterDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a parameter in fabric settings of the cluster.
 * @property name The parameter name of fabric setting.
 * @property value The parameter value of fabric setting.
 */
public data class SettingsParameterDescriptionArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.SettingsParameterDescriptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.SettingsParameterDescriptionArgs =
        com.pulumi.azurenative.servicefabric.inputs.SettingsParameterDescriptionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SettingsParameterDescriptionArgs].
 */
@PulumiTagMarker
public class SettingsParameterDescriptionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The parameter name of fabric setting.
     */
    @JvmName("jhilcspqhddmjpcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameter value of fabric setting.
     */
    @JvmName("motujqmytsljysjw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The parameter name of fabric setting.
     */
    @JvmName("mbukspmobcqmftjd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameter value of fabric setting.
     */
    @JvmName("eevjtqvdjqqeijrv")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SettingsParameterDescriptionArgs = SettingsParameterDescriptionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
